/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.model;

import com.github.fridujo.glacio.model.StepArgument;
import java.util.List;

public class DataTable
implements StepArgument {
    private final List<Row> rows;
    private final int minWidth;
    private final int maxWidth;

    public DataTable(List<Row> rows) {
        this.rows = rows;
        this.minWidth = rows.stream().mapToInt(Row::length).min().orElse(0);
        this.maxWidth = rows.stream().mapToInt(Row::length).max().orElse(0);
    }

    @Override
    public StepArgument.Type getType() {
        return StepArgument.Type.DATA_TABLE;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public boolean isSquare() {
        return this.minWidth == this.maxWidth;
    }

    public boolean hasWidth(int width) {
        return width <= this.minWidth;
    }

    public static class Row {
        private final List<String> cells;

        public Row(List<String> cells) {
            this.cells = cells;
        }

        public List<String> getCells() {
            return this.cells;
        }

        public int length() {
            return this.cells.size();
        }
    }
}

