/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.model;

import com.github.fridujo.glacio.model.Keyword;
import com.github.fridujo.glacio.model.StepArgument;
import java.util.List;
import java.util.Optional;

public class Step {
    private final boolean background;
    private final Optional<Keyword> keyword;
    private final String text;
    private final Optional<StepArgument> argument;
    private final List<Step> substeps;

    public Step(boolean background, Optional<Keyword> keyword, String text, Optional<StepArgument> argument, List<Step> substeps) {
        this.background = background;
        this.keyword = keyword;
        this.text = text;
        this.argument = argument;
        this.substeps = substeps;
    }

    public boolean isBackground() {
        return this.background;
    }

    public Optional<Keyword> getKeyword() {
        return this.keyword;
    }

    public String getText() {
        return this.text;
    }

    public Optional<StepArgument> getArgument() {
        return this.argument;
    }

    public List<Step> getSubsteps() {
        return this.substeps;
    }

    public String getLine() {
        return this.keyword.map(Keyword::getLiteral).orElse("") + this.text + (this.background ? " (background)" : "");
    }
}

