/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.parsing.charstream;

import com.github.fridujo.glacio.parsing.charstream.Position;
import java.util.Set;
import java.util.function.Predicate;

public class CharStream {
    private final String input;
    private int pos;
    private int line = 1;
    private int col;
    private boolean endReached;

    public CharStream(String input) {
        this.input = input.replace("\r", "").replace("\t", "    ");
    }

    public Character next() {
        Character ch = this.charAt(this.pos);
        if (ch != null) {
            this.updatePosition(ch);
        }
        return ch;
    }

    private void updatePosition(Character ch) {
        ++this.pos;
        if (ch.charValue() == '\n') {
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
    }

    public Character peek() {
        return this.charAt(this.pos);
    }

    public String peekUntil(Predicate<Character> charPredicate) {
        Character nextChar;
        StringBuilder sb = new StringBuilder();
        int peekPos = this.pos;
        while ((nextChar = this.charAt(peekPos)) != null && !charPredicate.test(nextChar)) {
            sb.append(nextChar);
            ++peekPos;
        }
        return sb.toString();
    }

    public String nextUntil(Predicate<Character> charPredicate) {
        Character nextChar;
        StringBuilder sb = new StringBuilder();
        int peekPos = this.pos;
        while ((nextChar = this.charAt(peekPos)) != null && !charPredicate.test(nextChar)) {
            ++peekPos;
            sb.append(nextChar);
            this.updatePosition(nextChar);
        }
        return sb.toString();
    }

    private Character charAt(int position) {
        if (this.input.length() <= position) {
            this.endReached = true;
            return null;
        }
        return Character.valueOf(this.input.charAt(position));
    }

    public boolean isEndReached() {
        return this.endReached;
    }

    public boolean anyStringAhead(Set<String> strings) {
        for (String s : strings) {
            int endOfString = this.pos + s.length();
            if (this.input.length() < endOfString || !s.equals(this.input.substring(this.pos, endOfString))) continue;
            return true;
        }
        return false;
    }

    public String nextMatchingString(Set<String> strings) {
        for (String s : strings) {
            int endOfString = this.pos + s.length();
            if (endOfString > this.input.length()) continue;
            String potentialMatch = this.input.substring(this.pos, endOfString);
            if (this.input.length() < endOfString || !s.equals(potentialMatch)) continue;
            this.pos = endOfString;
            this.col += potentialMatch.length();
            return potentialMatch;
        }
        return "";
    }

    public Position getPosition() {
        return new Position(this.line, this.col);
    }
}

