/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.parsing.lexer;

import com.github.fridujo.glacio.parsing.charstream.CharStream;
import com.github.fridujo.glacio.parsing.charstream.Position;
import com.github.fridujo.glacio.parsing.i18n.LanguageKeywords;
import com.github.fridujo.glacio.parsing.lexer.FixedTokenDefinition;
import com.github.fridujo.glacio.parsing.lexer.Token;
import com.github.fridujo.glacio.parsing.lexer.TokenSequence;
import com.github.fridujo.glacio.parsing.lexer.TokenType;
import com.github.fridujo.glacio.parsing.tool.Strings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Predicate;

public class Lexer {
    public static final Predicate<Character> IS_EOL = c -> c.charValue() == '\n';
    public static final Predicate<Character> IS_SPACE = c -> " \t".indexOf(c.charValue()) >= 0;
    public static final Predicate<Character> IS_PIPE = c -> c.charValue() == '|';
    public static final Predicate<Character> IS_COLON = c -> c.charValue() == ':';
    public static final Predicate<Character> IS_NOT_A_SPACE = IS_SPACE.negate();
    public static final Predicate<Character> IS_NOT_A_DOUBLE_QUOTE = c -> c.charValue() != '\"';
    private final Deque<Integer> indentations = new ArrayDeque<Integer>();
    private final Queue<Token> bufferedTokens = new LinkedList<Token>();
    private final CharStream charStream;
    private LanguageKeywords languageKeywords = LanguageKeywords.empty();

    public Lexer(CharStream charStream) {
        this.charStream = charStream;
        this.indentations.push(0);
    }

    public LanguageKeywords getLanguageKeywords() {
        return this.languageKeywords;
    }

    public void setLanguageKeywords(LanguageKeywords languageKeywords) {
        this.languageKeywords = languageKeywords;
    }

    public Token peek() {
        if (!this.bufferedTokens.isEmpty()) {
            return this.bufferedTokens.peek();
        }
        Token next = this.next();
        this.bufferedTokens.offer(next);
        return next;
    }

    public Token next() {
        Token nextToken;
        Position position = this.charStream.getPosition();
        if (this.charStream.getPosition().getColumn() == 0) {
            String indentationCharacters = this.charStream.nextUntil(IS_NOT_A_SPACE);
            this.computeIndentation(indentationCharacters, position);
        }
        if (!this.bufferedTokens.isEmpty()) {
            return this.bufferedTokens.poll();
        }
        String spaces = this.charStream.nextUntil(IS_NOT_A_SPACE);
        if (this.charStream.isEndReached()) {
            if (this.indentations.size() > 1) {
                this.indentations.pop();
                nextToken = new Token(TokenType.DEDENT, position);
            } else {
                nextToken = new Token(TokenType.EOF, position);
            }
        } else if (spaces.length() > 0) {
            nextToken = new Token(TokenType.SPACE, spaces, position);
        } else if (this.charStream.peek().charValue() == FixedTokenDefinition.EOL.getSingleCharacter()) {
            this.charStream.next();
            nextToken = new Token(FixedTokenDefinition.EOL, position);
        } else if (this.charStream.peek().charValue() == FixedTokenDefinition.COLON.getSingleCharacter()) {
            this.charStream.next();
            nextToken = new Token(FixedTokenDefinition.COLON, position);
        } else if (this.charStream.peek().charValue() == FixedTokenDefinition.TAG_DELIMITER.getSingleCharacter()) {
            this.charStream.next();
            nextToken = new Token(FixedTokenDefinition.TAG_DELIMITER, position);
        } else if (this.charStream.peek().charValue() == FixedTokenDefinition.COMMENT_DELIMITER.getSingleCharacter()) {
            this.charStream.next();
            nextToken = new Token(FixedTokenDefinition.COMMENT_DELIMITER, position);
        } else if (this.charStream.peek().charValue() == FixedTokenDefinition.TABLE_DELIMITER.getSingleCharacter()) {
            this.charStream.next();
            nextToken = new Token(FixedTokenDefinition.TABLE_DELIMITER, position);
        } else if (this.charStream.peekUntil(IS_NOT_A_DOUBLE_QUOTE).equals(FixedTokenDefinition.DOC_STRING_DELIMITER.getLiteralString())) {
            this.charStream.nextUntil(IS_NOT_A_DOUBLE_QUOTE);
            nextToken = new Token(FixedTokenDefinition.DOC_STRING_DELIMITER, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getFeature())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getFeature());
            nextToken = new Token(TokenType.FEATURE, literal, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getBackground())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getBackground());
            nextToken = new Token(TokenType.BACKGROUND, literal, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getScenarioOutline())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getScenarioOutline());
            nextToken = new Token(TokenType.SCENARIO_OUTLINE, literal, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getExamples())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getExamples());
            nextToken = new Token(TokenType.EXAMPLES, literal, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getScenario())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getScenario());
            nextToken = new Token(TokenType.SCENARIO, literal, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getGiven())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getGiven());
            nextToken = new Token(TokenType.GIVEN, literal, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getWhen())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getWhen());
            nextToken = new Token(TokenType.WHEN, literal, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getThen())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getThen());
            nextToken = new Token(TokenType.THEN, literal, position);
        } else if (this.charStream.anyStringAhead(this.languageKeywords.getAnd())) {
            String literal = this.charStream.nextMatchingString(this.languageKeywords.getAnd());
            nextToken = new Token(TokenType.AND, literal, position);
        } else {
            String literal = this.charStream.nextUntil(IS_EOL.or(IS_SPACE).or(IS_PIPE).or(IS_COLON));
            nextToken = new Token(TokenType.TEXT, literal, position);
        }
        return nextToken;
    }

    public Token peekNextNonBlankToken() {
        Token token;
        ArrayList<Token> blankTokensAccumulator = new ArrayList<Token>();
        while (true) {
            token = this.next();
            if (!token.isOfAnyType(TokenType.SPACE, TokenType.EOL, TokenType.INDENT, TokenType.DEDENT)) break;
            blankTokensAccumulator.add(token);
        }
        blankTokensAccumulator.add(token);
        blankTokensAccumulator.forEach(this.bufferedTokens::offer);
        return token;
    }

    public void skipBlanksAndEOL() {
        this.skipTokensOfType(TokenType.SPACE, TokenType.EOL, TokenType.INDENT, TokenType.DEDENT);
    }

    public void skipBlanks() {
        this.skipTokensOfType(TokenType.SPACE, TokenType.INDENT, TokenType.DEDENT);
    }

    public void skipTokensOfType(TokenType ... tokenTypes) {
        Token token;
        while ((token = this.next()).isOfAnyType(tokenTypes)) {
        }
        this.bufferedTokens.offer(token);
    }

    public TokenSequence consumeUntil(TokenType ... tokenTypes) {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        while (!this.peek().isOfAnyType(tokenTypes)) {
            tokenList.add(this.next());
        }
        return new TokenSequence(this.charStream.getPosition(), tokenList);
    }

    public TokenSequence consumeUntilNextLine() {
        TokenSequence tokenSequence = this.consumeUntil(TokenType.EOL, TokenType.EOF);
        this.next();
        return tokenSequence;
    }

    private void computeIndentation(String literal, Position position) {
        int spaceCount = this.countSpaces(literal);
        Integer previousIndentation = this.indentations.peek();
        if (previousIndentation < spaceCount) {
            this.indentations.push(spaceCount);
            String remainingIndent = literal.substring(previousIndentation);
            this.bufferedTokens.offer(new Token(TokenType.INDENT, remainingIndent, position));
        } else if (this.indentations.peek() != spaceCount) {
            while (this.indentations.peek() > spaceCount) {
                this.indentations.pop();
                this.bufferedTokens.offer(new Token(TokenType.DEDENT, position));
            }
            if (this.indentations.peek() < spaceCount) {
                this.bufferedTokens.offer(new Token(TokenType.INDENT, Strings.repeat(' ', spaceCount - this.indentations.peek()), position));
                this.indentations.push(spaceCount);
            }
        }
    }

    private int countSpaces(String spaces) {
        return spaces.length();
    }
}

