/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.List;
import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class IntFunction
extends AbstractFunction {
    private smile.math.IntFunction lambda;

    public IntFunction(String name, Term x, smile.math.IntFunction lambda) {
        super(name, x);
        this.lambda = lambda;
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final Feature feature : this.x.bind(schema)) {
            final StructField xfield = feature.field();
            final DataType type = xfield.type;
            if (!(type.isInt() || type.isShort() || type.isByte())) {
                throw new IllegalStateException(String.format("Invalid expression: %s(%s)", this.name, type));
            }
            features.add(new Feature(){
                StructField field;
                {
                    this.field = new StructField(String.format("%s(%s)", IntFunction.this.name, xfield.name), type.id() == DataType.ID.Object ? DataTypes.IntegerObjectType : DataTypes.IntegerType, xfield.measure);
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public Integer apply(Tuple o) {
                    Object y = feature.apply(o);
                    if (y == null) {
                        return null;
                    }
                    return IntFunction.this.lambda.apply(((Number)y).intValue());
                }

                @Override
                public int applyAsInt(Tuple o) {
                    return IntFunction.this.lambda.apply(feature.applyAsInt(o));
                }
            });
        }
        return features;
    }
}

