/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Function;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;

public interface DotProductKernel
extends Function {
    @Override
    default public double f(double dot) {
        return this.k(dot);
    }

    public double k(double var1);

    public double[] kg(double var1);

    @Override
    default public double apply(double dot) {
        return this.k(dot);
    }

    default public Matrix K(Matrix pdot) {
        if (pdot.nrows() != pdot.ncols()) {
            throw new IllegalArgumentException("pdot is not square");
        }
        int n = pdot.nrows();
        Matrix K = new Matrix(n, n);
        for (int j = 0; j < n; ++j) {
            K.set(j, j, this.k(pdot.get(j, j)));
            for (int i = j + 1; i < n; ++i) {
                double k = this.k(pdot.get(i, j));
                K.set(i, j, k);
                K.set(j, i, k);
            }
        }
        K.uplo(UPLO.LOWER);
        return K;
    }
}

