/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.math.matrix.DMatrix;
import smile.math.matrix.Preconditioner;

public class BiconjugateGradient {
    private static final Logger logger = LoggerFactory.getLogger(BiconjugateGradient.class);

    public static Preconditioner Jacobi(DMatrix A) {
        return (b, x) -> {
            double[] diag = A.diag();
            int n = diag.length;
            for (int i = 0; i < n; ++i) {
                x[i] = diag[i] != 0.0 ? b[i] / diag[i] : b[i];
            }
        };
    }

    public static double solve(DMatrix A, double[] b, double[] x) {
        return BiconjugateGradient.solve(A, b, x, BiconjugateGradient.Jacobi(A), 1.0E-6, 1, 2 * Math.max(A.nrows(), A.ncols()));
    }

    public static double solve(DMatrix A, double[] b, double[] x, Preconditioner preconditioner, double tol, int itol, int maxIter) {
        double bnrm;
        int j;
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (itol < 1 || itol > 4) {
            throw new IllegalArgumentException("Invalid itol: " + itol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum iterations: " + maxIter);
        }
        double err = 0.0;
        double bkden = 1.0;
        double znrm = 0.0;
        int n = b.length;
        double[] p = new double[n];
        double[] pp = new double[n];
        double[] r = new double[n];
        double[] rr = new double[n];
        double[] z = new double[n];
        double[] zz = new double[n];
        A.mv(x, r);
        for (j = 0; j < n; ++j) {
            r[j] = b[j] - r[j];
            rr[j] = r[j];
        }
        if (itol == 1) {
            bnrm = BiconjugateGradient.norm(b, itol);
            preconditioner.solve(r, z);
        } else if (itol == 2) {
            preconditioner.solve(b, z);
            bnrm = BiconjugateGradient.norm(z, itol);
            preconditioner.solve(r, z);
        } else if (itol == 3 || itol == 4) {
            preconditioner.solve(b, z);
            bnrm = BiconjugateGradient.norm(z, itol);
            preconditioner.solve(r, z);
            znrm = BiconjugateGradient.norm(z, itol);
        } else {
            throw new IllegalArgumentException(String.format("Illegal itol: %d", itol));
        }
        for (int iter = 1; iter <= maxIter; ++iter) {
            preconditioner.solve(rr, zz);
            double bknum = 0.0;
            for (j = 0; j < n; ++j) {
                bknum += z[j] * rr[j];
            }
            if (iter == 1) {
                for (j = 0; j < n; ++j) {
                    p[j] = z[j];
                    pp[j] = zz[j];
                }
            } else {
                double bk = bknum / bkden;
                for (j = 0; j < n; ++j) {
                    p[j] = bk * p[j] + z[j];
                    pp[j] = bk * pp[j] + zz[j];
                }
            }
            bkden = bknum;
            A.mv(p, z);
            double akden = 0.0;
            for (j = 0; j < n; ++j) {
                akden += z[j] * pp[j];
            }
            double ak = bknum / akden;
            A.tv(pp, zz);
            for (j = 0; j < n; ++j) {
                int n2 = j;
                x[n2] = x[n2] + ak * p[j];
                int n3 = j;
                r[n3] = r[n3] - ak * z[j];
                int n4 = j;
                rr[n4] = rr[n4] - ak * zz[j];
            }
            preconditioner.solve(r, z);
            if (itol == 1) {
                err = BiconjugateGradient.norm(r, itol) / bnrm;
            } else if (itol == 2) {
                err = BiconjugateGradient.norm(z, itol) / bnrm;
            } else if (itol == 3 || itol == 4) {
                double zm1nrm = znrm;
                if (!(Math.abs(zm1nrm - (znrm = BiconjugateGradient.norm(z, itol))) > MathEx.EPSILON * znrm)) {
                    err = znrm / bnrm;
                    continue;
                }
                double dxnrm = Math.abs(ak) * BiconjugateGradient.norm(p, itol);
                err = znrm / Math.abs(zm1nrm - znrm) * dxnrm;
                double xnrm = BiconjugateGradient.norm(x, itol);
                if (err <= 0.5 * xnrm) {
                    err /= xnrm;
                } else {
                    err = znrm / bnrm;
                    continue;
                }
            }
            if (iter % 10 == 0) {
                logger.info(String.format("BCG: the error after %3d iterations: %.5g", iter, err));
            }
            if (!(err <= tol)) continue;
            logger.info(String.format("BCG: the error after %3d iterations: %.5g", iter, err));
            break;
        }
        return err;
    }

    private static double norm(double[] x, int itol) {
        int n = x.length;
        if (itol <= 3) {
            double ans = 0.0;
            for (int i = 0; i < n; ++i) {
                ans += x[i] * x[i];
            }
            return Math.sqrt(ans);
        }
        int isamax = 0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(x[i]) > Math.abs(x[isamax]))) continue;
            isamax = i;
        }
        return Math.abs(x[isamax]);
    }
}

