/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import smile.sort.QuickSort;
import smile.util.DoubleArrayList;
import smile.util.IntArrayList;
import smile.util.Strings;

public class SparseArray
implements Iterable<Entry>,
Serializable {
    private static final long serialVersionUID = 2L;
    private IntArrayList index;
    private DoubleArrayList value;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        this.index = new IntArrayList(initialCapacity);
        this.value = new DoubleArrayList(initialCapacity);
    }

    public SparseArray(List<Entry> entries) {
        this.index = new IntArrayList(entries.size());
        this.value = new DoubleArrayList(entries.size());
        for (Entry e : entries) {
            this.index.add(e.i);
            this.value.add(e.x);
        }
    }

    public SparseArray(Stream<Entry> stream) {
        this(stream.collect(Collectors.toList()));
    }

    public String toString() {
        return this.stream().map(Entry::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    public int size() {
        return this.index.size();
    }

    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iterator<Entry>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SparseArray.this.size();
            }

            @Override
            public Entry next() {
                return new Entry(this.i++);
            }
        };
    }

    public Stream<Entry> stream() {
        return IntStream.range(0, this.size()).mapToObj(i -> new Entry(i));
    }

    public void sort() {
        QuickSort.sort(this.index.data, this.value.data, this.size());
    }

    public double get(int i) {
        int length = this.size();
        for (int k = 0; k < length; ++k) {
            if (this.index.get(k) != i) continue;
            return this.value.get(k);
        }
        return 0.0;
    }

    public boolean set(int i, double x) {
        if (x == 0.0) {
            this.remove(i);
            return false;
        }
        int length = this.size();
        for (int k = 0; k < length; ++k) {
            if (this.index.get(k) != i) continue;
            this.value.set(k, x);
            return false;
        }
        this.index.add(i);
        this.value.add(x);
        return true;
    }

    public void append(int i, double x) {
        if (x != 0.0) {
            this.index.add(i);
            this.value.add(x);
        }
    }

    public void remove(int i) {
        int length = this.size();
        for (int k = 0; k < length; ++k) {
            if (this.index.get(k) != i) continue;
            this.index.remove(k);
            this.value.remove(k);
            return;
        }
    }

    public class Entry {
        public final int i;
        public final double x;
        private final int index;

        private Entry(int index) {
            this.i = SparseArray.this.index.get(index);
            this.x = SparseArray.this.value.get(index);
            this.index = index;
        }

        public void update(double x) {
            SparseArray.this.value.set(this.index, x);
        }

        public String toString() {
            return String.format("%d:%s", this.i, Strings.format(this.x));
        }
    }
}

