/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow;

import com.github.havardh.javaflow.Execution;
import com.github.havardh.javaflow.model.TypeMap;
import com.github.havardh.javaflow.phases.filetransform.CommentPrependTransformer;
import com.github.havardh.javaflow.phases.filetransform.EslintDisableTransformer;
import com.github.havardh.javaflow.phases.parser.java.JavaParser;
import com.github.havardh.javaflow.phases.reader.FileReader;
import com.github.havardh.javaflow.phases.transform.InheritanceTransformer;
import com.github.havardh.javaflow.phases.transform.SortedTypeTransformer;
import com.github.havardh.javaflow.phases.verifier.ClassGetterNamingVerifier;
import com.github.havardh.javaflow.phases.verifier.MemberFieldsPresentVerifier;
import com.github.havardh.javaflow.phases.verifier.Verifier;
import com.github.havardh.javaflow.phases.writer.flow.FlowWriter;
import com.github.havardh.javaflow.phases.writer.flow.converter.JavaFlowConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JavaFlow {
    private static String VERIFY_GETTERS_ARG = "--verifyGetters";
    private static List<String> ARGS = Collections.singletonList(VERIFY_GETTERS_ARG);

    public static void main(String[] args) {
        TypeMap typeMap = new TypeMap("types.yml");
        JavaFlowConverter converter = new JavaFlowConverter(typeMap);
        ArrayList<Verifier> verifierList = new ArrayList<Verifier>();
        verifierList.add(new MemberFieldsPresentVerifier(typeMap));
        if (Arrays.stream(args).anyMatch(arg -> arg.equals(VERIFY_GETTERS_ARG))) {
            verifierList.add(new ClassGetterNamingVerifier());
        }
        Execution execution = new Execution(new FileReader(), new JavaParser(), Arrays.asList(new InheritanceTransformer(), new SortedTypeTransformer()), verifierList, new FlowWriter(converter), Arrays.asList(new CommentPrependTransformer("Generated by javaflow 1.4.1"), new EslintDisableTransformer(Collections.singletonList("no-use-before-define")), new CommentPrependTransformer("@flow")));
        System.out.println(execution.run(JavaFlow.filterOutArgs(args)));
    }

    private static String[] filterOutArgs(String[] args) {
        return (String[])Arrays.stream(args).filter(arg -> !ARGS.contains(arg)).toArray(String[]::new);
    }
}

