/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.ast;

import com.github.havardh.javaflow.ast.Field;
import com.github.havardh.javaflow.ast.Method;
import com.github.havardh.javaflow.ast.Parent;
import com.github.havardh.javaflow.ast.Type;
import com.github.havardh.javaflow.model.CanonicalName;
import com.github.havardh.javaflow.util.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Class
extends Type {
    private final Parent parent;
    private final List<Field> fields;
    private final List<Method> getters;

    public Class(CanonicalName name, Parent parent, List<Field> fields, List<Method> getters) {
        super(name);
        this.parent = parent;
        this.fields = fields;
        this.getters = getters;
    }

    public List<Field> getFields() {
        return Lists.concat(this.getParentFields(), this.fields);
    }

    private List<Field> getParentFields() {
        return this.getParent().map(Parent::getFields).orElse(Collections.emptyList());
    }

    private List<Method> getParentGetters() {
        return this.getParent().map(Parent::getGetters).orElse(Collections.emptyList());
    }

    public Optional<Parent> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public List<Method> getGetters() {
        return Lists.concat(this.getParentGetters(), this.getters);
    }
}

