/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.ast.builders;

import com.github.havardh.javaflow.ast.List;
import com.github.havardh.javaflow.ast.Map;
import com.github.havardh.javaflow.ast.Type;
import com.github.havardh.javaflow.model.CanonicalName;

public final class TypeBuilder {
    protected CanonicalName name;
    private CanonicalName firstName;
    private CanonicalName secondName;

    private TypeBuilder() {
    }

    public static TypeBuilder type() {
        return new TypeBuilder();
    }

    public static Type primitive(CanonicalName name) {
        return new Type(name);
    }

    public static Type object(CanonicalName name) {
        return new Type(name);
    }

    public static Type list(CanonicalName name, CanonicalName type) {
        return new List(name, type);
    }

    public static Type map(CanonicalName name, CanonicalName key, CanonicalName value) {
        return new Map(name, key, value);
    }

    public TypeBuilder withName(CanonicalName name) {
        this.name = name;
        return this;
    }

    public TypeBuilder withListType(CanonicalName name) {
        this.firstName = name;
        this.secondName = null;
        return this;
    }

    public TypeBuilder withMapType(CanonicalName key, CanonicalName value) {
        this.firstName = key;
        this.secondName = value;
        return this;
    }

    public Type build() {
        if (this.secondName != null) {
            return TypeBuilder.map(this.name, this.firstName, this.secondName);
        }
        if (this.firstName != null) {
            return TypeBuilder.list(this.name, this.firstName);
        }
        return TypeBuilder.object(this.name);
    }
}

