/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.exceptions;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AggregatedException
extends RuntimeException {
    private final boolean showEnumerationInErrors;
    private final List<Exception> exceptions;

    public AggregatedException(String message, List<Exception> exceptions, boolean showEnumerationInErrors) {
        super(message);
        this.exceptions = exceptions;
        this.showEnumerationInErrors = showEnumerationInErrors;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\n" + this.getSubMessages();
    }

    private String getSubMessages() {
        return IntStream.range(0, this.exceptions.size()).mapToObj(i -> this.getSubmessagePrefix(i) + this.exceptions.get(i).getMessage()).collect(Collectors.joining("\n\n"));
    }

    private String getSubmessagePrefix(int errorNumber) {
        return this.showEnumerationInErrors ? String.format("%d) ", errorNumber + 1) : "";
    }
}

