/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.model;

import com.github.havardh.javaflow.model.builders.CanonicalNameBuilder;

public class CanonicalName {
    private final String packageName;
    private final String name;

    private CanonicalName(String packageName, String name) {
        this.packageName = packageName;
        this.name = name;
    }

    public static CanonicalName fromString(String canonicalName) {
        int lastDot = canonicalName.lastIndexOf(46);
        return CanonicalNameBuilder.canonicalName().withPackageName(canonicalName.substring(0, lastDot)).withName(canonicalName.substring(lastDot + 1, canonicalName.length())).build();
    }

    public static CanonicalName primitive(String name) {
        return new CanonicalName(null, name);
    }

    public static CanonicalName object(String packageName, String name) {
        return new CanonicalName(packageName, name);
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalName that = (CanonicalName)o;
        if (this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.packageName != null ? String.format("%s.%s", this.packageName, this.name) : this.name;
    }
}

