/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.phases.parser.java;

import com.github.havardh.javaflow.ast.Field;
import com.github.havardh.javaflow.ast.Method;
import com.github.havardh.javaflow.ast.Parent;
import com.github.havardh.javaflow.ast.builders.ClassBuilder;
import com.github.havardh.javaflow.phases.parser.java.CanonicalNameFactory;
import com.github.havardh.javaflow.phases.parser.java.TypeFactory;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassVisitor
extends VoidVisitorAdapter<ClassBuilder> {
    private String packageName;
    private Map<String, String> imports = new HashMap<String, String>();

    public void visit(PackageDeclaration n, ClassBuilder builder) {
        super.visit(n, (Object)builder);
        this.packageName = n.getPackageName();
        builder.withPackageName(n.getPackageName());
    }

    public void visit(ImportDeclaration n, ClassBuilder builder) {
        super.visit(n, (Object)builder);
        String[] packages = n.getName().toString().split("\\.");
        String typeName = n.getName().getName();
        String packageName = Stream.of(packages).limit(packages.length - 1).collect(Collectors.joining("."));
        this.imports.put(typeName, packageName);
    }

    public void visit(ClassOrInterfaceDeclaration n, ClassBuilder builder) {
        super.visit(n, (Object)builder);
        builder.withName(n.getName());
        CanonicalNameFactory factory = new CanonicalNameFactory(this.packageName, this.imports);
        if (this.isClass(n)) {
            n.getExtends().stream().findFirst().ifPresent(parent -> builder.withParent(new Parent(factory.build(parent.getName()))));
        }
    }

    public void visit(FieldDeclaration field, ClassBuilder builder) {
        super.visit(field, (Object)builder);
        TypeFactory factory = new TypeFactory(this.packageName, this.imports);
        field.getVariables().forEach(variable -> builder.withField(new Field(this.isNullable(field), variable.getId().getName(), factory.build(field.getType().toString(), field.getType() instanceof PrimitiveType))));
    }

    public void visit(MethodDeclaration method, ClassBuilder builder) {
        super.visit(method, (Object)builder);
        TypeFactory factory = new TypeFactory(this.packageName, this.imports);
        if (this.isClass((ClassOrInterfaceDeclaration)method.getParentNode()) && this.isGetter(method.getName(), method.getType().toString())) {
            builder.withGetter(new Method(method.getName(), factory.build(method.getType().toString(), method.getType() instanceof PrimitiveType)));
        }
    }

    private boolean isNullable(FieldDeclaration field) {
        return field.getAnnotations().stream().map(AnnotationExpr::getName).map(NameExpr::getName).filter(name -> name.equals("Nullable")).count() > 0L;
    }

    private boolean isClass(ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        return !classOrInterfaceDeclaration.isInterface();
    }

    private boolean isGetter(String name, String type) {
        if (Arrays.asList("boolean", "Boolean").contains(type) && name.startsWith("is")) {
            return true;
        }
        return name.startsWith("get");
    }
}

