/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.phases.parser.java;

import com.github.havardh.javaflow.ast.Type;
import com.github.havardh.javaflow.ast.builders.Builder;
import com.github.havardh.javaflow.ast.builders.ClassBuilder;
import com.github.havardh.javaflow.ast.builders.EnumBuilder;
import com.github.havardh.javaflow.phases.parser.Parser;
import com.github.havardh.javaflow.phases.parser.java.ClassVisitor;
import com.github.havardh.javaflow.phases.parser.java.EnumVisitor;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;

public class JavaParser
implements Parser {
    @Override
    public Optional<Type> parse(String source) {
        try {
            CompilationUnit cu = com.github.javaparser.JavaParser.parse((Reader)new StringReader(source));
            return JavaParser.convert(cu);
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(1);
            return Optional.empty();
        }
    }

    private static Optional<Type> convert(CompilationUnit cu) {
        if (JavaParser.containsClass(cu)) {
            return Optional.of(JavaParser.convert(cu, ClassBuilder.classBuilder(), (VoidVisitor)new ClassVisitor()));
        }
        if (JavaParser.containsEnum(cu)) {
            return Optional.of(JavaParser.convert(cu, EnumBuilder.enumBuilder(), (VoidVisitor)new EnumVisitor()));
        }
        return Optional.empty();
    }

    private static <T extends Type> T convert(CompilationUnit cu, Builder<T> builder, VoidVisitor visitor) {
        visitor.visit(cu, builder);
        return (T)((Type)builder.build());
    }

    private static boolean containsEnum(CompilationUnit cu) {
        return cu.getTypes().stream().filter(t -> t instanceof EnumDeclaration).findFirst().isPresent();
    }

    private static boolean containsClass(CompilationUnit cu) {
        return cu.getTypes().stream().filter(t -> t instanceof ClassOrInterfaceDeclaration).findFirst().isPresent();
    }
}

