/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.phases.parser.java;

import com.github.havardh.javaflow.ast.Type;
import com.github.havardh.javaflow.ast.builders.TypeBuilder;
import com.github.havardh.javaflow.model.CanonicalName;
import com.github.havardh.javaflow.phases.parser.java.CanonicalNameFactory;
import java.util.Map;

public class TypeFactory {
    private CanonicalNameFactory canonicalNameFactory;

    public TypeFactory(String packageName, Map<String, String> imports) {
        this.canonicalNameFactory = new CanonicalNameFactory(packageName, imports);
    }

    public Type build(String typeLiteral, boolean isPrimitive) {
        if (TypeFactory.isList(typeLiteral) || TypeFactory.isSet(typeLiteral)) {
            String tagType = TypeFactory.extractTagType(typeLiteral);
            String valType = TypeFactory.extractType(typeLiteral);
            return TypeBuilder.list(this.canonicalNameFactory.build(tagType), this.canonicalNameFactory.build(valType));
        }
        if (TypeFactory.isMap(typeLiteral)) {
            String tagType = TypeFactory.extractTagType(typeLiteral);
            String keyType = TypeFactory.extractKeyType(typeLiteral);
            String valType = TypeFactory.extractValueType(typeLiteral);
            return TypeBuilder.map(this.canonicalNameFactory.build(tagType), this.canonicalNameFactory.build(keyType), this.canonicalNameFactory.build(valType));
        }
        if (isPrimitive || typeLiteral.equals("char[]")) {
            return TypeBuilder.primitive(CanonicalName.primitive(typeLiteral));
        }
        return TypeBuilder.object(this.canonicalNameFactory.build(typeLiteral));
    }

    private static boolean isList(String typeLiteral) {
        return typeLiteral.startsWith("List<") && typeLiteral.endsWith(">") || typeLiteral.startsWith("Collection<") && typeLiteral.endsWith(">");
    }

    private static boolean isSet(String typeLiteral) {
        return typeLiteral.startsWith("Set<") && typeLiteral.endsWith(">");
    }

    private static boolean isMap(String typeLiteral) {
        return typeLiteral.startsWith("Map<") && typeLiteral.endsWith(">");
    }

    private static String extractTagType(String typeLiteral) {
        return typeLiteral.substring(0, typeLiteral.indexOf("<"));
    }

    private static String extractType(String typeLiteral) {
        return typeLiteral.substring(typeLiteral.indexOf("<") + 1, typeLiteral.length() - 1);
    }

    private static String extractKeyType(String typeLiteral) {
        int index = typeLiteral.indexOf(",");
        return typeLiteral.substring(4, index);
    }

    private static String extractValueType(String typeLiteral) {
        int index = typeLiteral.indexOf(",");
        return typeLiteral.substring(index + 2, typeLiteral.length() - 1);
    }
}

