/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.phases.transform;

import com.github.havardh.javaflow.ast.Class;
import com.github.havardh.javaflow.ast.Parent;
import com.github.havardh.javaflow.ast.Type;
import com.github.havardh.javaflow.phases.transform.Transformer;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InheritanceTransformer
implements Transformer {
    @Override
    public void transform(List<Type> types) {
        List<Class> classes = types.stream().filter(type -> type instanceof Class).map(type -> (Class)type).collect(Collectors.toList());
        Map<String, Class> typeMap = classes.stream().collect(Collectors.toMap(Type::toString, Function.identity()));
        classes.forEach(InheritanceTransformer.setParentReference(typeMap));
    }

    private static Consumer<Class> setParentReference(Map<String, Class> typeMap) {
        return aClass -> aClass.getParent().ifPresent(InheritanceTransformer.updateParentReference(typeMap));
    }

    private static Consumer<Parent> updateParentReference(Map<String, Class> typeMap) {
        return parent -> parent.setReference((Class)typeMap.get(parent.getCanonicalName().toString()));
    }
}

