/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.phases.verifier;

import com.github.havardh.javaflow.ast.Class;
import com.github.havardh.javaflow.ast.Field;
import com.github.havardh.javaflow.ast.Method;
import com.github.havardh.javaflow.ast.Type;
import com.github.havardh.javaflow.exceptions.AggregatedException;
import com.github.havardh.javaflow.exceptions.FieldGettersMismatchException;
import com.github.havardh.javaflow.phases.verifier.Verifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassGetterNamingVerifier
implements Verifier {
    @Override
    public void verify(List<Type> types) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Type type : types) {
            if (!(type instanceof Class)) continue;
            exceptions.addAll(this.validate((Class)type));
        }
        if (!exceptions.isEmpty()) {
            throw new AggregatedException("Class getter naming validation failed with following errors:\n", exceptions, true);
        }
    }

    private List<Exception> validate(Class classToValidate) {
        List<Method> getters = classToValidate.getGetters();
        List<Field> fields = classToValidate.getFields();
        if (getters.size() != fields.size()) {
            return Collections.singletonList(new FieldGettersMismatchException(classToValidate.getCanonicalName(), String.format("Number of getters and fields is not the same.\nFields in model: %s\nGetters in model: %s", fields, getters)));
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Method getter : getters) {
            try {
                Field correspondingField = this.findFieldByGetter(classToValidate, fields, getter);
                if (correspondingField.getType().equals(getter.getType())) continue;
                throw new FieldGettersMismatchException(classToValidate.getCanonicalName(), String.format("Type of getter %s (%s) does not correspond to field %s (%s)", getter.getName(), getter.getType(), correspondingField.getName(), correspondingField.getType()));
            }
            catch (FieldGettersMismatchException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    private Field findFieldByGetter(Class classToValidate, List<Field> fields, Method getter) throws FieldGettersMismatchException {
        return fields.stream().filter(field -> field.getName().equals(ClassGetterNamingVerifier.convertGetterNameToFieldName(getter.getName()))).findFirst().orElseThrow(() -> new FieldGettersMismatchException(classToValidate.getCanonicalName(), String.format("Name of getter %s does not correspond to any field name.", getter.getName())));
    }

    private static String convertGetterNameToFieldName(String getterName) {
        if (getterName.startsWith("get") && getterName.length() > 3) {
            return Character.toLowerCase(getterName.charAt(3)) + (getterName.length() > 4 ? getterName.substring(4) : "");
        }
        if (getterName.startsWith("is") && getterName.length() > 2) {
            return Character.toLowerCase(getterName.charAt(2)) + (getterName.length() > 4 ? getterName.substring(3) : "");
        }
        return getterName;
    }
}

