/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.phases.verifier;

import com.github.havardh.javaflow.ast.Class;
import com.github.havardh.javaflow.ast.Field;
import com.github.havardh.javaflow.ast.Type;
import com.github.havardh.javaflow.exceptions.MissingTypeException;
import com.github.havardh.javaflow.model.TypeMap;
import com.github.havardh.javaflow.phases.verifier.Verifier;
import com.github.havardh.javaflow.phases.writer.flow.converter.definitions.Objects;
import com.github.havardh.javaflow.phases.writer.flow.converter.definitions.Primitives;
import com.github.havardh.javaflow.util.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MemberFieldsPresentVerifier
implements Verifier {
    private final TypeMap customTypes;

    public MemberFieldsPresentVerifier(TypeMap customTypes) {
        this.customTypes = customTypes;
    }

    @Override
    public void verify(List<Type> types) {
        Set nameSet = types.stream().map(Type::getCanonicalName).collect(Collectors.toSet());
        HashMap<Type, List<Field>> missingTypes = new HashMap<Type, List<Field>>();
        for (Type type : types.stream().filter(t -> t instanceof Class).collect(Collectors.toList())) {
            ((Class)type).getFields().stream().filter(field -> !nameSet.contains(field.getType().getCanonicalName())).filter(field -> !Objects.isObject(field.getType().toString())).filter(field -> !Primitives.isPrimitive(field.getType().toString())).filter(field -> !this.customTypes.containsKey(field.getType().toString())).forEach(field -> missingTypes.compute(type, (ignored, fields) -> fields == null ? Collections.singletonList(field) : Lists.concat(fields, Collections.singletonList(field))));
        }
        if (!missingTypes.isEmpty()) {
            throw new MissingTypeException(missingTypes);
        }
    }
}

