/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.phases.writer.flow;

import com.github.havardh.javaflow.ast.List;
import com.github.havardh.javaflow.ast.Map;
import com.github.havardh.javaflow.ast.Type;
import com.github.havardh.javaflow.phases.writer.Writer;
import com.github.havardh.javaflow.phases.writer.flow.converter.Converter;
import java.io.IOException;

public class TypeWriter
implements Writer<Type> {
    private final Converter converter;

    public TypeWriter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public void write(Type type, java.io.Writer writer) throws IOException {
        if (type instanceof Map) {
            this.write((Map)type, writer);
        } else if (type instanceof List) {
            this.write((List)type, writer);
        } else {
            writer.write(this.converter.convert(type.getCanonicalName()));
        }
    }

    @Override
    private void write(Map map, java.io.Writer writer) throws IOException {
        writer.write("{[key: ");
        writer.write(this.converter.convert(map.getKeyType()));
        writer.write("]: ");
        writer.write(this.converter.convert(map.getValueType()));
        writer.write("}");
    }

    @Override
    private void write(List list, java.io.Writer writer) throws IOException {
        writer.write(this.converter.convert(list.getCanonicalName()));
        writer.write("<");
        writer.write(this.converter.convert(list.getType()));
        writer.write(">");
    }
}

