/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.phases.writer.flow.converter;

import com.github.havardh.javaflow.model.CanonicalName;
import com.github.havardh.javaflow.model.TypeMap;
import com.github.havardh.javaflow.phases.writer.flow.converter.Converter;
import com.github.havardh.javaflow.phases.writer.flow.converter.definitions.Objects;
import com.github.havardh.javaflow.phases.writer.flow.converter.definitions.Primitives;

public final class JavaFlowConverter
implements Converter {
    private final TypeMap customTypeMap;

    public JavaFlowConverter() {
        this.customTypeMap = TypeMap.emptyTypeMap();
    }

    public JavaFlowConverter(TypeMap typeMap) {
        this.customTypeMap = typeMap;
    }

    @Override
    public String convert(CanonicalName canonicalName) {
        String name = canonicalName.getName();
        String fullName = canonicalName.toString();
        return this.customTypeMap.getOrDefault(fullName, JavaFlowConverter.getOrDefault(fullName, name));
    }

    private static String getOrDefault(String name, String defaultName) {
        if (Objects.isObject(name)) {
            return Objects.get(name);
        }
        if (Primitives.isPrimitive(name)) {
            return Primitives.get(name);
        }
        return defaultName;
    }
}

