/*
 * Decompiled with CFR 0.152.
 */
package com.github.havardh.javaflow.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class Maps {
    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> collect(Map.Entry<K, V> ... entries) {
        return Collections.unmodifiableMap(Arrays.stream(entries).collect(Maps.entriesToMap()));
    }

    private static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }
}

