/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.freedesktop.dbus.MessageReader;
import org.freedesktop.dbus.MessageWriter;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.SASL;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransport
implements Closeable {
    private final Logger logger;
    private final BusAddress address;
    private SASL.SaslMode saslMode;
    private int saslAuthMode;
    private MessageReader inputReader;
    private MessageWriter outputWriter;

    AbstractTransport(BusAddress _address) {
        this.address = _address;
        this.saslMode = _address.isListeningSocket() ? SASL.SaslMode.SERVER : SASL.SaslMode.CLIENT;
        this.saslAuthMode = 0;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void writeMessage(Message _msg) throws IOException {
        if (this.outputWriter == null || this.outputWriter.isClosed()) {
            throw new IOException("OutputWriter already closed or null");
        }
        this.outputWriter.writeMessage(_msg);
    }

    public Message readMessage() throws IOException, DBusException {
        if (this.inputReader != null && !this.inputReader.isClosed()) {
            return this.inputReader.readMessage();
        }
        throw new IOException("InputReader already closed or null");
    }

    abstract void connect() throws IOException;

    protected void authenticate(OutputStream _out, InputStream _in, Socket _sock) throws IOException {
        if (!new SASL().auth(this.saslMode, this.saslAuthMode, this.address.getGuid(), _out, _in, _sock)) {
            _out.close();
            throw new IOException("Failed to auth");
        }
    }

    protected void setOutputWriter(OutputStream _outputStream) {
        this.outputWriter = new MessageWriter(_outputStream);
    }

    protected void setInputReader(InputStream _inputStream) {
        this.inputReader = new MessageReader(_inputStream);
    }

    protected int getSaslAuthMode() {
        return this.saslAuthMode;
    }

    protected void setSaslAuthMode(int _saslAuthMode) {
        this.saslAuthMode = _saslAuthMode;
    }

    protected SASL.SaslMode getSaslMode() {
        return this.saslMode;
    }

    protected void setSaslMode(SASL.SaslMode _saslMode) {
        this.saslMode = _saslMode;
    }

    protected BusAddress getAddress() {
        return this.address;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public void close() throws IOException {
        this.inputReader.close();
        this.outputWriter.close();
    }
}

