/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.commons.logging;

import com.github.igorsuhorukov.apache.commons.logging.Log;
import com.github.igorsuhorukov.apache.commons.logging.LogConfigurationException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class LogFactory {
    public static final String PRIORITY_KEY = "priority";
    public static final String TCCL_KEY = "use_tccl";
    public static final String FACTORY_PROPERTY = "com.github.igorsuhorukov.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "com.github.igorsuhorukov.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "com.github.igorsuhorukov.apache.commons.logging.diagnostics.dest";
    private static PrintStream diagnosticsStream;
    private static final String diagnosticPrefix;
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "com.github.igorsuhorukov.apache.commons.logging.LogFactory.HashtableImpl";
    private static final String WEAK_HASHTABLE_CLASSNAME = "com.github.igorsuhorukov.apache.commons.logging.impl.WeakHashtable";
    private static final ClassLoader thisClassLoader;
    protected static Hashtable factories;
    protected static volatile LogFactory nullClassLoaderFactory;
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    /*
     * WARNING - void declaration
     */
    private static final Hashtable createFactoryStore() {
        void var0;
        Hashtable result;
        block7: {
            String storeImplementationClass;
            result = null;
            try {
                storeImplementationClass = LogFactory.getSystemProperty(HASHTABLE_IMPLEMENTATION_PROPERTY, null);
            }
            catch (SecurityException securityException) {
                storeImplementationClass = null;
            }
            if (storeImplementationClass == null) {
                storeImplementationClass = WEAK_HASHTABLE_CLASSNAME;
            }
            try {
                Class<?> clazz = Class.forName(storeImplementationClass);
                result = (Hashtable)clazz.newInstance();
            }
            catch (Throwable throwable) {
                void var1_1;
                Throwable throwable2 = throwable;
                LogFactory.handleThrowable(throwable);
                if (WEAK_HASHTABLE_CLASSNAME.equals(var1_1)) break block7;
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[ERROR] LogFactory: Load of custom hashtable failed");
                }
                System.err.println("[ERROR] LogFactory: Load of custom hashtable failed");
            }
        }
        if (result == null) {
            result = new Hashtable();
        }
        return var0;
    }

    private static String trim(String src) {
        String string;
        if (src == null) {
            return null;
        }
        return string.trim();
    }

    protected static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            Throwable throwable;
            throw (VirtualMachineError)throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static LogFactory getFactory() throws LogConfigurationException {
        void var1_1;
        String factoryClass;
        Properties props;
        LogFactory factory;
        ClassLoader contextClassLoader;
        block38: {
            String useTCCLStr;
            contextClassLoader = LogFactory.getContextClassLoaderInternal();
            if (contextClassLoader == null && LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Context classloader is null.");
            }
            if ((factory = LogFactory.getCachedFactory(contextClassLoader)) != null) {
                return factory;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] LogFactory implementation requested for the first time for context classloader " + LogFactory.objectId(contextClassLoader));
                LogFactory.logHierarchy("[LOOKUP] ", contextClassLoader);
            }
            props = LogFactory.getConfigurationFile(contextClassLoader, FACTORY_PROPERTIES);
            ClassLoader baseClassLoader = contextClassLoader;
            if (props != null && (useTCCLStr = props.getProperty(TCCL_KEY)) != null && !Boolean.valueOf(useTCCLStr).booleanValue()) {
                baseClassLoader = thisClassLoader;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] Looking for system property [org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
            }
            try {
                factoryClass = LogFactory.getSystemProperty(FACTORY_PROPERTY, null);
                if (factoryClass != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] Creating an instance of LogFactory class '" + factoryClass + "' as specified by system property org.apache.commons.logging.LogFactory");
                    }
                    factory = LogFactory.newFactory(factoryClass, baseClassLoader, contextClassLoader);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] No system property [org.apache.commons.logging.LogFactory] defined.");
                }
            }
            catch (SecurityException e) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(e.getMessage()) + "]. Trying alternative implementations...");
                }
            }
            catch (RuntimeException e) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] An exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(e.getMessage()) + "] as specified by a system property.");
                }
                throw e;
            }
            if (factory == null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Looking for a resource file of name [META-INF/services/org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
                }
                try {
                    InputStream is = LogFactory.getResourceAsStream(contextClassLoader, SERVICE_ID);
                    if (is != null) {
                        BufferedReader rd;
                        try {
                            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            rd = new BufferedReader(new InputStreamReader(is));
                        }
                        String factoryClassName = rd.readLine();
                        rd.close();
                        if (factoryClassName != null && !"".equals(factoryClassName)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("[LOOKUP]  Creating an instance of LogFactory class " + factoryClassName + " as specified by file 'META-INF/services/org.apache.commons.logging.LogFactory" + "' which was present in the path of the context classloader.");
                            }
                            factory = LogFactory.newFactory(factoryClassName, baseClassLoader, contextClassLoader);
                        }
                        break block38;
                    }
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] No resource file with name 'META-INF/services/org.apache.commons.logging.LogFactory' found.");
                    }
                }
                catch (Exception ex) {
                    if (!LogFactory.isDiagnosticsEnabled()) break block38;
                    LogFactory.logDiagnostic("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + LogFactory.trim(ex.getMessage()) + "]. Trying alternative implementations...");
                }
            }
        }
        if (factory == null) {
            if (props != null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Looking in properties file for entry with key 'org.apache.commons.logging.LogFactory' to define the LogFactory subclass to use...");
                }
                if ((factoryClass = props.getProperty(FACTORY_PROPERTY)) != null) {
                    void var3_3;
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] Properties file specifies LogFactory subclass '" + factoryClass + "'");
                    }
                    factory = LogFactory.newFactory(factoryClass, (ClassLoader)var3_3, contextClassLoader);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Properties file has no entry specifying LogFactory subclass.");
                }
            } else if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] No properties file available to determine LogFactory subclass from..");
            }
        }
        if (factory == null) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] Loading the default LogFactory implementation 'org.apache.commons.logging.impl.LogFactoryImpl' via the same classloader that loaded this LogFactory class (ie not looking in the context classloader).");
            }
            factory = LogFactory.newFactory(FACTORY_DEFAULT, thisClassLoader, contextClassLoader);
        }
        if (factory != null) {
            void var0;
            LogFactory.cacheFactory((ClassLoader)var0, factory);
            if (props != null) {
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = props.getProperty(name);
                    factory.setAttribute(name, value);
                }
            }
        }
        return var1_1;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        Class clazz2;
        return LogFactory.getFactory().getInstance(clazz2);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        String string;
        return LogFactory.getFactory().getInstance(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void release(ClassLoader classLoader) {
        Hashtable factories;
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("Releasing factory for classloader " + LogFactory.objectId(classLoader));
        }
        Hashtable hashtable = factories = LogFactory.factories;
        synchronized (factories) {
            if (classLoader == null) {
                if (nullClassLoaderFactory != null) {
                    nullClassLoaderFactory.release();
                    nullClassLoaderFactory = null;
                }
            } else {
                LogFactory factory = (LogFactory)factories.get(classLoader);
                if (factory != null) {
                    ClassLoader classLoader2;
                    void var1_2;
                    void var3_4;
                    var3_4.release();
                    var1_2.remove(classLoader2);
                }
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void releaseAll() {
        Hashtable factories;
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("Releasing factory for all classloaders.");
        }
        Hashtable hashtable = factories = LogFactory.factories;
        synchronized (factories) {
            void var0;
            Enumeration elements = factories.elements();
            while (elements.hasMoreElements()) {
                LogFactory logFactory = (LogFactory)elements.nextElement();
                logFactory.release();
            }
            var0.clear();
            if (nullClassLoaderFactory != null) {
                nullClassLoaderFactory.release();
                nullClassLoaderFactory = null;
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static ClassLoader getClassLoader(Class clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException ex) {
            void var1_1;
            if (LogFactory.isDiagnosticsEnabled()) {
                Class clazz2;
                LogFactory.logDiagnostic("Unable to get classloader for class '" + clazz2 + "' due to security restrictions - " + ex.getMessage());
            }
            throw var1_1;
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.directGetContextClassLoader();
    }

    private static ClassLoader getContextClassLoaderInternal() throws LogConfigurationException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return LogFactory.directGetContextClassLoader();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected static ClassLoader directGetContextClassLoader() throws LogConfigurationException {
        void var0;
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {}
        return var0;
    }

    private static LogFactory getCachedFactory(ClassLoader contextClassLoader) {
        ClassLoader classLoader;
        if (contextClassLoader == null) {
            return nullClassLoaderFactory;
        }
        return (LogFactory)factories.get(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private static void cacheFactory(ClassLoader classLoader, LogFactory factory) {
        if (factory != null) {
            void var1_1;
            ClassLoader classLoader2;
            if (classLoader == null) {
                nullClassLoaderFactory = factory;
                return;
            }
            factories.put(classLoader2, var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static LogFactory newFactory(final String factoryClass, ClassLoader classLoader, ClassLoader contextClassLoader) throws LogConfigurationException {
        LogConfigurationException logConfigurationException;
        void var1_1;
        LogConfigurationException result = AccessController.doPrivileged(new PrivilegedAction((ClassLoader)var1_1){
            private final /* synthetic */ ClassLoader val$classLoader;
            {
                this.val$classLoader = classLoader;
            }

            public final Object run() {
                return LogFactory.createFactory(factoryClass, this.val$classLoader);
            }
        });
        if (result instanceof LogConfigurationException) {
            LogConfigurationException ex = result;
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("An error occurred while loading the factory class:" + ex.getMessage());
            }
            throw logConfigurationException;
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            void var2_2;
            LogFactory.logDiagnostic("Created object " + LogFactory.objectId(logConfigurationException) + " to manage classloader " + LogFactory.objectId(var2_2));
        }
        return (LogFactory)((Object)logConfigurationException);
    }

    /*
     * WARNING - void declaration
     */
    protected static LogFactory newFactory(String factoryClass, ClassLoader classLoader) {
        void var1_1;
        return LogFactory.newFactory(factoryClass, (ClassLoader)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    protected static Object createFactory(String factoryClass, ClassLoader classLoader) {
        Class<?> logFactoryClass = null;
        try {
            String string;
            block21: {
                if (classLoader != null) {
                    try {
                        logFactoryClass = classLoader.loadClass(factoryClass);
                        if ((class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).isAssignableFrom(logFactoryClass)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Loaded class " + logFactoryClass.getName() + " from classloader " + LogFactory.objectId(classLoader));
                            }
                        } else if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic("Factory class " + logFactoryClass.getName() + " loaded from classloader " + LogFactory.objectId(logFactoryClass.getClassLoader()) + " does not extend '" + (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getName() + "' as loaded by this classloader.");
                            LogFactory.logHierarchy("[BAD CL TREE] ", classLoader);
                        }
                        return (LogFactory)logFactoryClass.newInstance();
                    }
                    catch (ClassNotFoundException ex) {
                        if (classLoader == thisClassLoader) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Unable to locate any class called '" + factoryClass + "' via classloader " + LogFactory.objectId(classLoader));
                            }
                            throw ex;
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        if (classLoader == thisClassLoader) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Class '" + factoryClass + "' cannot be loaded via classloader " + LogFactory.objectId(classLoader) + " - it depends on some other class that cannot be found.");
                            }
                            throw e;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        void var1_2;
                        if (classLoader != thisClassLoader) break block21;
                        boolean implementsLogFactory = LogFactory.implementsLogFactory(logFactoryClass);
                        StringBuffer msg = new StringBuffer();
                        msg.append("The application has specified that a custom LogFactory implementation ");
                        msg.append("should be used but Class '");
                        msg.append(factoryClass);
                        msg.append("' cannot be converted to '");
                        msg.append((class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getName());
                        msg.append("'. ");
                        if (var1_2 != false) {
                            msg.append("The conflict is caused by the presence of multiple LogFactory classes ");
                            msg.append("in incompatible classloaders. ");
                            msg.append("Background can be found in http://commons.apache.org/logging/tech.html. ");
                            msg.append("If you have not explicitly specified a custom LogFactory then it is likely ");
                            msg.append("that the container has set one without your knowledge. ");
                            msg.append("In this case, consider using the commons-logging-adapters.jar file or ");
                            msg.append("specifying the standard LogFactory from the command line. ");
                        } else {
                            msg.append("Please check the custom implementation. ");
                        }
                        msg.append("Help can be found @http://commons.apache.org/logging/troubleshooting.html.");
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic(msg.toString());
                        }
                        throw new ClassCastException(msg.toString());
                    }
                }
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                void var1_1;
                LogFactory.logDiagnostic("Unable to load factory class via classloader " + LogFactory.objectId(var1_1) + " - trying the classloader associated with this LogFactory.");
            }
            logFactoryClass = Class.forName(string);
            return (LogFactory)logFactoryClass.newInstance();
        }
        catch (Exception e) {
            void var3_7;
            void var2_3;
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to create LogFactory instance.");
            }
            if (logFactoryClass != null && !(class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).isAssignableFrom((Class<?>)var2_3)) {
                return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", e);
            }
            return new LogConfigurationException((Throwable)var3_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean implementsLogFactory(Class logFactoryClass) {
        void var1_1;
        boolean implementsLogFactory = false;
        if (logFactoryClass != null) {
            try {
                Object logFactoryClassLoader = logFactoryClass.getClassLoader();
                if (logFactoryClassLoader == null) {
                    LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] was loaded by the boot classloader");
                } else {
                    LogFactory.logHierarchy("[CUSTOM LOG FACTORY] ", (ClassLoader)logFactoryClassLoader);
                    logFactoryClassLoader = Class.forName(FACTORY_PROPERTY, false, (ClassLoader)logFactoryClassLoader);
                    implementsLogFactory = ((Class)logFactoryClassLoader).isAssignableFrom(logFactoryClass);
                    if (implementsLogFactory) {
                        LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] " + logFactoryClass.getName() + " implements LogFactory but was loaded by an incompatible classloader.");
                    } else {
                        Class clazz;
                        LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] " + clazz.getName() + " does not implement LogFactory.");
                    }
                }
            }
            catch (SecurityException e) {
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] SecurityException thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: " + e.getMessage());
            }
            catch (LinkageError e) {
                void var2_4;
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] LinkageError thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: " + var2_4.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] LogFactory class cannot be loaded by classloader which loaded the custom LogFactory implementation. Is the custom factory in the right classloader?");
            }
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static InputStream getResourceAsStream(ClassLoader loader, String name) {
        void var1_1;
        ClassLoader classLoader;
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction((String)var1_1){
            private final /* synthetic */ String val$name;
            {
                this.val$name = string;
            }

            public final Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(this.val$name);
                }
                return ClassLoader.getSystemResourceAsStream(this.val$name);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static Enumeration getResources(ClassLoader loader, String name) {
        void var1_1;
        Object object;
        object = new PrivilegedAction((ClassLoader)object, (String)var1_1){
            private final /* synthetic */ ClassLoader val$loader;
            private final /* synthetic */ String val$name;
            {
                this.val$loader = classLoader;
                this.val$name = string;
            }

            /*
             * WARNING - void declaration
             */
            public final Object run() {
                try {
                    if (this.val$loader != null) {
                        return this.val$loader.getResources(this.val$name);
                    }
                    return ClassLoader.getSystemResources(this.val$name);
                }
                catch (IOException e) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        void var1_1;
                        LogFactory.logDiagnostic("Exception while trying to find configuration file " + this.val$name + ":" + var1_1.getMessage());
                    }
                    return null;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return null;
                }
            }
        };
        object = AccessController.doPrivileged(object);
        return (Enumeration)object;
    }

    private static Properties getProperties(URL url) {
        PrivilegedAction privilegedAction;
        privilegedAction = new PrivilegedAction((URL)((Object)privilegedAction)){
            private final /* synthetic */ URL val$url;
            {
                this.val$url = uRL;
            }

            /*
             * Loose catch block
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object run() {
                InputStream stream = null;
                URLConnection connection = this.val$url.openConnection();
                connection.setUseCaches(false);
                stream = connection.getInputStream();
                if (stream != null) {
                    void var2_2;
                    Properties props = new Properties();
                    props.load(stream);
                    stream.close();
                    return var2_2;
                }
                if (stream == null) return null;
                try {
                    stream.close();
                    return null;
                }
                catch (IOException iOException) {
                    if (!LogFactory.isDiagnosticsEnabled()) return null;
                    LogFactory.logDiagnostic("Unable to close stream for URL " + this.val$url);
                }
                return null;
                catch (IOException iOException) {
                    try {
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic("Unable to read URL " + this.val$url);
                        }
                        if (stream == null) return null;
                    }
                    catch (Throwable throwable) {
                        if (stream == null) throw throwable;
                        try {
                            void var1_1;
                            var1_1.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {
                            if (!LogFactory.isDiagnosticsEnabled()) throw throwable;
                            LogFactory.logDiagnostic("Unable to close stream for URL " + this.val$url);
                        }
                        throw throwable;
                    }
                    try {
                        stream.close();
                        return null;
                    }
                    catch (IOException iOException3) {
                        if (!LogFactory.isDiagnosticsEnabled()) return null;
                        LogFactory.logDiagnostic("Unable to close stream for URL " + this.val$url);
                    }
                    return null;
                }
            }
        };
        return (Properties)AccessController.doPrivileged(privilegedAction);
    }

    /*
     * WARNING - void declaration
     */
    private static final Properties getConfigurationFile(ClassLoader classLoader, String fileName) {
        void var2_2;
        URL propsUrl;
        Properties props;
        block12: {
            props = null;
            double priority = 0.0;
            propsUrl = null;
            try {
                Enumeration urls = LogFactory.getResources(classLoader, fileName);
                if (urls == null) {
                    return null;
                }
                while (urls.hasMoreElements()) {
                    URL url = (URL)urls.nextElement();
                    Properties newProps = LogFactory.getProperties(url);
                    if (newProps == null) continue;
                    if (props == null) {
                        propsUrl = url;
                        props = newProps;
                        String priorityStr = props.getProperty(PRIORITY_KEY);
                        priority = 0.0;
                        if (priorityStr != null) {
                            priority = Double.parseDouble(priorityStr);
                        }
                        if (!LogFactory.isDiagnosticsEnabled()) continue;
                        LogFactory.logDiagnostic("[LOOKUP] Properties file found at '" + url + "' with priority " + priority);
                        continue;
                    }
                    String newPriorityStr = newProps.getProperty(PRIORITY_KEY);
                    double newPriority = 0.0;
                    if (newPriorityStr != null) {
                        newPriority = Double.parseDouble(newPriorityStr);
                    }
                    if (newPriority > priority) {
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic("[LOOKUP] Properties file at '" + url + "' with priority " + newPriority + " overrides file at '" + propsUrl + "' with priority " + priority);
                        }
                        propsUrl = url;
                        props = newProps;
                        priority = newPriority;
                        continue;
                    }
                    if (!LogFactory.isDiagnosticsEnabled()) continue;
                    LogFactory.logDiagnostic("[LOOKUP] Properties file at '" + url + "' with priority " + newPriority + " does not override file at '" + propsUrl + "' with priority " + priority);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactory.isDiagnosticsEnabled()) break block12;
                LogFactory.logDiagnostic("SecurityException thrown while trying to find/read config files.");
            }
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            if (props == null) {
                LogFactory.logDiagnostic("[LOOKUP] No properties file of name '" + fileName + "' found.");
            } else {
                void var1_1;
                LogFactory.logDiagnostic("[LOOKUP] Properties file of name '" + (String)var1_1 + "' found at '" + propsUrl + '\"');
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static String getSystemProperty(String key, String def) throws SecurityException {
        void var1_1;
        String string;
        return (String)AccessController.doPrivileged(new PrivilegedAction((String)var1_1){
            private final /* synthetic */ String val$def;
            {
                this.val$def = string2;
            }

            public final Object run() {
                return System.getProperty(string, this.val$def);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static PrintStream initDiagnostics() {
        String dest;
        try {
            dest = LogFactory.getSystemProperty(DIAGNOSTICS_DEST_PROPERTY, null);
            if (dest == null) {
                return null;
            }
        }
        catch (SecurityException securityException) {
            return null;
        }
        if (dest.equals("STDOUT")) {
            return System.out;
        }
        if (dest.equals("STDERR")) {
            return System.err;
        }
        try {
            void var0;
            FileOutputStream fos = new FileOutputStream(dest, true);
            return new PrintStream((OutputStream)var0);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static boolean isDiagnosticsEnabled() {
        return diagnosticsStream != null;
    }

    private static final void logDiagnostic(String msg) {
        if (diagnosticsStream != null) {
            String string;
            diagnosticsStream.print(diagnosticPrefix);
            diagnosticsStream.println(string);
            diagnosticsStream.flush();
        }
    }

    protected static final void logRawDiagnostic(String msg) {
        if (diagnosticsStream != null) {
            String string;
            diagnosticsStream.println(string);
            diagnosticsStream.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logClassLoaderEnvironment(Class clazz) {
        ClassLoader classLoader;
        void var1_1;
        ClassLoader classLoader2;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        try {
            LogFactory.logDiagnostic("[ENV] Extension directories (java.ext.dir): " + System.getProperty("java.ext.dir"));
            LogFactory.logDiagnostic("[ENV] Application classpath (java.class.path): " + System.getProperty("java.class.path"));
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic("[ENV] Security setting prevent interrogation of system classpaths.");
        }
        String className = clazz.getName();
        try {
            classLoader2 = LogFactory.getClassLoader(clazz);
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic("[ENV] Security forbids determining the classloader for " + className);
            return;
        }
        LogFactory.logDiagnostic("[ENV] Class " + className + " was loaded via classloader " + LogFactory.objectId(classLoader2));
        LogFactory.logHierarchy("[ENV] Ancestry of classloader which loaded " + (String)var1_1 + " is ", classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private static void logHierarchy(String prefix, ClassLoader classLoader) {
        ClassLoader systemClassLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        if (classLoader != null) {
            String classLoaderString = classLoader.toString();
            LogFactory.logDiagnostic(prefix + LogFactory.objectId(classLoader) + " == '" + classLoaderString + "'");
        }
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic(prefix + "Security forbids determining the system classloader.");
            return;
        }
        if (classLoader != null) {
            void var2_2;
            block9: {
                String string;
                StringBuffer buf = new StringBuffer(string + "ClassLoader tree:");
                do {
                    buf.append(LogFactory.objectId(classLoader));
                    if (classLoader == systemClassLoader) {
                        buf.append(" (SYSTEM) ");
                    }
                    try {
                        classLoader = classLoader.getParent();
                    }
                    catch (SecurityException securityException) {
                        buf.append(" --> SECRET");
                        break block9;
                    }
                    buf.append(" --> ");
                } while (classLoader != null);
                buf.append("BOOT");
            }
            LogFactory.logDiagnostic(var2_2.toString());
        }
    }

    public static String objectId(Object o) {
        Object object;
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(object);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            void var0_1;
            throw new NoClassDefFoundError(var0_1.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        String classLoaderName;
        diagnosticsStream = null;
        factories = null;
        nullClassLoaderFactory = null;
        thisClassLoader = LogFactory.getClassLoader(class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory);
        try {
            ClassLoader classLoader = thisClassLoader;
            classLoaderName = thisClassLoader == null ? "BOOTLOADER" : LogFactory.objectId(classLoaderName);
        }
        catch (SecurityException securityException) {
            classLoaderName = "UNKNOWN";
        }
        diagnosticPrefix = "[LogFactory from " + (String)var0 + "] ";
        diagnosticsStream = LogFactory.initDiagnostics();
        LogFactory.logClassLoaderEnvironment(class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory);
        factories = LogFactory.createFactoryStore();
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("BOOTSTRAP COMPLETED");
        }
    }
}

