/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.commons.logging.impl;

import com.github.igorsuhorukov.apache.commons.logging.Log;
import com.github.igorsuhorukov.apache.commons.logging.LogConfigurationException;
import com.github.igorsuhorukov.apache.commons.logging.LogFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class LogFactoryImpl
extends LogFactory {
    private static final String LOGGING_IMPL_LOG4J_LOGGER = "com.github.igorsuhorukov.apache.commons.logging.impl.Log4JLogger";
    private static final String LOGGING_IMPL_JDK14_LOGGER = "com.github.igorsuhorukov.apache.commons.logging.impl.Jdk14Logger";
    private static final String LOGGING_IMPL_LUMBERJACK_LOGGER = "com.github.igorsuhorukov.apache.commons.logging.impl.Jdk13LumberjackLogger";
    private static final String LOGGING_IMPL_SIMPLE_LOGGER = "com.github.igorsuhorukov.apache.commons.logging.impl.SimpleLog";
    private static final String PKG_IMPL = "com.github.igorsuhorukov.apache.commons.logging.impl.";
    private static final int PKG_LEN = 32;
    public static final String LOG_PROPERTY = "com.github.igorsuhorukov.apache.commons.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "com.github.igorsuhorukov.apache.commons.logging.log";
    public static final String ALLOW_FLAWED_CONTEXT_PROPERTY = "com.github.igorsuhorukov.apache.commons.logging.Log.allowFlawedContext";
    public static final String ALLOW_FLAWED_DISCOVERY_PROPERTY = "com.github.igorsuhorukov.apache.commons.logging.Log.allowFlawedDiscovery";
    public static final String ALLOW_FLAWED_HIERARCHY_PROPERTY = "com.github.igorsuhorukov.apache.commons.logging.Log.allowFlawedHierarchy";
    private static final String[] classesToDiscover = new String[]{"com.github.igorsuhorukov.apache.commons.logging.impl.Log4JLogger", "com.github.igorsuhorukov.apache.commons.logging.impl.Jdk14Logger", "com.github.igorsuhorukov.apache.commons.logging.impl.Jdk13LumberjackLogger", "com.github.igorsuhorukov.apache.commons.logging.impl.SimpleLog"};
    private boolean useTCCL = true;
    private String diagnosticPrefix;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable instances = new Hashtable();
    private String logClassName;
    protected Constructor logConstructor = null;
    protected Class[] logConstructorSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LogFactoryImpl.class$("java.lang.String")) : class$java$lang$String};
    protected Method logMethod = null;
    protected Class[] logMethodSignature = new Class[]{class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactoryImpl.class$("com.github.igorsuhorukov.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory};
    private boolean allowFlawedContext;
    private boolean allowFlawedDiscovery;
    private boolean allowFlawedHierarchy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;
    static /* synthetic */ Class class$org$apache$commons$logging$impl$LogFactoryImpl;
    static /* synthetic */ Class class$org$apache$commons$logging$Log;

    public LogFactoryImpl() {
        this.initDiagnostics();
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Instance created.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String name) {
        void var1_1;
        return this.attributes.get(var1_1);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public Log getInstance(Class clazz) throws LogConfigurationException {
        void var1_1;
        return this.getInstance(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    public Log getInstance(String name) throws LogConfigurationException {
        void var2_2;
        Log instance = (Log)this.instances.get(name);
        if (instance == null) {
            void var1_1;
            instance = this.newInstance(name);
            this.instances.put(var1_1, instance);
        }
        return var2_2;
    }

    public void release() {
        this.logDiagnostic("Releasing all known loggers");
        this.instances.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void removeAttribute(String name) {
        void var1_1;
        this.attributes.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String name, Object value) {
        void var1_1;
        if (this.logConstructor != null) {
            this.logDiagnostic("setAttribute: call too late; configuration already performed.");
        }
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        if (var1_1.equals("use_tccl")) {
            void var2_2;
            this.useTCCL = value != null && Boolean.valueOf(var2_2.toString()) != false;
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.getContextClassLoader();
    }

    protected static boolean isDiagnosticsEnabled() {
        return LogFactory.isDiagnosticsEnabled();
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        return LogFactory.getClassLoader(clazz);
    }

    private void initDiagnostics() {
        String classLoaderName;
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = LogFactoryImpl.getClassLoader(clazz);
        try {
            classLoaderName = classLoader == null ? "BOOTLOADER" : LogFactoryImpl.objectId(classLoaderName);
        }
        catch (SecurityException securityException) {
            classLoaderName = "UNKNOWN";
        }
        this.diagnosticPrefix = "[LogFactoryImpl@" + System.identityHashCode(this) + " from " + clazz + "] ";
    }

    /*
     * WARNING - void declaration
     */
    protected void logDiagnostic(String msg) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            void var1_1;
            LogFactoryImpl.logRawDiagnostic(this.diagnosticPrefix + (String)var1_1);
        }
    }

    protected String getLogClassName() {
        if (this.logClassName == null) {
            this.discoverLogImplementation(this.getClass().getName());
        }
        return this.logClassName;
    }

    protected Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor == null) {
            this.discoverLogImplementation(this.getClass().getName());
        }
        return this.logConstructor;
    }

    protected boolean isJdk13LumberjackAvailable() {
        return this.isLogLibraryAvailable("Jdk13Lumberjack", LOGGING_IMPL_LUMBERJACK_LOGGER);
    }

    protected boolean isJdk14Available() {
        return this.isLogLibraryAvailable("Jdk14", LOGGING_IMPL_JDK14_LOGGER);
    }

    protected boolean isLog4JAvailable() {
        return this.isLogLibraryAvailable("Log4J", LOGGING_IMPL_LOG4J_LOGGER);
    }

    /*
     * WARNING - void declaration
     */
    protected Log newInstance(String name) throws LogConfigurationException {
        try {
            Object[] params;
            Log instance;
            if (this.logConstructor == null) {
                instance = this.discoverLogImplementation(name);
            } else {
                params = new Object[]{instance};
                instance = (Log)this.logConstructor.newInstance(params);
            }
            if (this.logMethod != null) {
                params = new Object[]{this};
                this.logMethod.invoke((Object)instance, params);
            }
            return instance;
        }
        catch (LogConfigurationException logConfigurationException) {
            LogConfigurationException params = logConfigurationException;
            throw logConfigurationException;
        }
        catch (InvocationTargetException invocationTargetException) {
            void var1_1;
            InvocationTargetException e = invocationTargetException;
            Throwable c = invocationTargetException.getTargetException();
            throw new LogConfigurationException((Throwable)(c == null ? e : var1_1));
        }
        catch (Throwable throwable) {
            void var2_5;
            Throwable t = throwable;
            LogFactoryImpl.handleThrowable(throwable);
            throw new LogConfigurationException((Throwable)var2_5);
        }
    }

    private static ClassLoader getContextClassLoaderInternal() throws LogConfigurationException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return LogFactoryImpl.directGetContextClassLoader();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static String getSystemProperty(String key, String def) throws SecurityException {
        void var1_1;
        String string;
        return (String)AccessController.doPrivileged(new PrivilegedAction((String)var1_1){
            private final /* synthetic */ String val$def;
            {
                this.val$def = string2;
            }

            public final Object run() {
                return System.getProperty(string, this.val$def);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private ClassLoader getParentClassLoader(ClassLoader cl) {
        try {
            void var1_1;
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(this, (ClassLoader)var1_1){
                private final /* synthetic */ ClassLoader val$cl;
                {
                    this.val$cl = classLoader;
                }

                public final Object run() {
                    return this.val$cl.getParent();
                }
            });
        }
        catch (SecurityException securityException) {
            this.logDiagnostic("[SECURITY] Unable to obtain parent classloader");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isLogLibraryAvailable(String name, String classname) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Checking for '" + name + "'.");
        }
        try {
            Log log;
            log = this.createLogFromClass((String)((Object)log), this.getClass().getName(), false);
            if (log == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Did not find '" + name + "'.");
                }
                return false;
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Found '" + name + "'.");
            }
            return true;
        }
        catch (LogConfigurationException logConfigurationException) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                void var1_1;
                this.logDiagnostic("Logging system '" + (String)var1_1 + "' is available but not useable.");
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getConfigurationValue(String property) {
        block10: {
            Object valueObj;
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] Trying to get configuration for item " + property);
            }
            if ((valueObj = this.getAttribute(property)) != null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] Found LogFactory attribute [" + valueObj + "] for " + property);
                }
                return valueObj.toString();
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] No LogFactory attribute found for " + property);
            }
            try {
                String value = LogFactoryImpl.getSystemProperty(property, null);
                if (value != null) {
                    void var2_2;
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("[ENV] Found system property [" + value + "] for " + property);
                    }
                    return var2_2;
                }
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] No system property found for property " + property);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactoryImpl.isDiagnosticsEnabled()) break block10;
                this.logDiagnostic("[ENV] Security prevented reading system property " + property);
            }
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            void var1_1;
            this.logDiagnostic("[ENV] No configuration defined for item " + (String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean getBooleanConfiguration(String key, boolean dflt) {
        void var1_1;
        String val = this.getConfigurationValue(key);
        if (val == null) {
            void var2_2;
            return (boolean)var2_2;
        }
        return Boolean.valueOf((String)var1_1);
    }

    private void initConfiguration() {
        this.allowFlawedContext = this.getBooleanConfiguration(ALLOW_FLAWED_CONTEXT_PROPERTY, true);
        this.allowFlawedDiscovery = this.getBooleanConfiguration(ALLOW_FLAWED_DISCOVERY_PROPERTY, true);
        this.allowFlawedHierarchy = this.getBooleanConfiguration(ALLOW_FLAWED_HIERARCHY_PROPERTY, true);
    }

    /*
     * WARNING - void declaration
     */
    private Log discoverLogImplementation(String logCategory) throws LogConfigurationException {
        void var2_2;
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Discovering a Log implementation...");
        }
        this.initConfiguration();
        Log result = null;
        String specifiedLogClassName = this.findUserSpecifiedLogClassName();
        if (specifiedLogClassName != null) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Attempting to load user-specified log class '" + specifiedLogClassName + "'...");
            }
            if ((result = this.createLogFromClass(specifiedLogClassName, logCategory, true)) == null) {
                void var3_3;
                StringBuffer messageBuffer = new StringBuffer("User-specified log class '");
                messageBuffer.append(specifiedLogClassName);
                messageBuffer.append("' cannot be found or is not useable.");
                this.informUponSimilarName(messageBuffer, specifiedLogClassName, LOGGING_IMPL_LOG4J_LOGGER);
                this.informUponSimilarName(messageBuffer, specifiedLogClassName, LOGGING_IMPL_JDK14_LOGGER);
                this.informUponSimilarName(messageBuffer, specifiedLogClassName, LOGGING_IMPL_LUMBERJACK_LOGGER);
                this.informUponSimilarName(messageBuffer, (String)var3_3, LOGGING_IMPL_SIMPLE_LOGGER);
                throw new LogConfigurationException(messageBuffer.toString());
            }
            return result;
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("No user-specified Log implementation; performing discovery using the standard supported logging implementations...");
        }
        for (int i = 0; i < classesToDiscover.length && result == null; ++i) {
            result = this.createLogFromClass(classesToDiscover[i], logCategory, true);
        }
        if (result == null) {
            throw new LogConfigurationException("No suitable Log implementation");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void informUponSimilarName(StringBuffer messageBuffer, String name, String candidate) {
        void var2_2;
        if (name.equals(candidate)) {
            return;
        }
        if (var2_2.regionMatches(true, 0, candidate, 0, PKG_LEN + 5)) {
            void var1_1;
            void var3_3;
            messageBuffer.append(" Did you mean '");
            messageBuffer.append((String)var3_3);
            var1_1.append("'?");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String findUserSpecifiedLogClassName() {
        void var1_1;
        String specifiedClass;
        block13: {
            block12: {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.Log'");
                }
                if ((specifiedClass = (String)this.getAttribute(LOG_PROPERTY)) == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.log'");
                    }
                    specifiedClass = (String)this.getAttribute(LOG_PROPERTY_OLD);
                }
                if (specifiedClass == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.Log'");
                    }
                    try {
                        specifiedClass = LogFactoryImpl.getSystemProperty(LOG_PROPERTY, null);
                    }
                    catch (SecurityException e) {
                        if (!LogFactoryImpl.isDiagnosticsEnabled()) break block12;
                        this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.Log' - " + e.getMessage());
                    }
                }
            }
            if (specifiedClass == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.log'");
                }
                try {
                    specifiedClass = LogFactoryImpl.getSystemProperty(LOG_PROPERTY_OLD, null);
                }
                catch (SecurityException e) {
                    void var2_3;
                    if (!LogFactoryImpl.isDiagnosticsEnabled()) break block13;
                    this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.log' - " + var2_3.getMessage());
                }
            }
        }
        if (specifiedClass != null) {
            specifiedClass = specifiedClass.trim();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Log createLogFromClass(String logAdapterClassName, String logCategory, boolean affectState) throws LogConfigurationException {
        void var3_3;
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Attempting to instantiate '" + logAdapterClassName + "'");
        }
        Object[] params = new Object[]{logCategory};
        Log logAdapter = null;
        Constructor constructor = null;
        Class<?> logAdapterClass = null;
        ClassLoader currentCL = this.getBaseClassLoader();
        while (true) {
            String msg;
            Object msg2;
            this.logDiagnostic("Trying to load '" + logAdapterClassName + "' from classloader " + LogFactoryImpl.objectId(currentCL));
            try {
                Object resourceName;
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    resourceName = logAdapterClassName.replace('.', '/') + ".class";
                    URL url = currentCL != null ? currentCL.getResource((String)resourceName) : ClassLoader.getSystemResource((String)resourceName + ".class");
                    if (url == null) {
                        this.logDiagnostic("Class '" + logAdapterClassName + "' [" + (String)resourceName + "] cannot be found.");
                    } else {
                        this.logDiagnostic("Class '" + logAdapterClassName + "' was found at '" + url + "'");
                    }
                }
                try {
                    Class<?> c = Class.forName(logAdapterClassName, true, currentCL);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    resourceName = classNotFoundException;
                    msg2 = classNotFoundException.getMessage();
                    this.logDiagnostic("The log adapter '" + logAdapterClassName + "' is not available via classloader " + LogFactoryImpl.objectId(currentCL) + ": " + ((String)msg2).trim());
                    try {
                        msg2 = Class.forName(logAdapterClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        msg2 = classNotFoundException2;
                        msg2 = classNotFoundException2.getMessage();
                        this.logDiagnostic("The log adapter '" + logAdapterClassName + "' is not available via the LogFactoryImpl class classloader: " + ((String)msg2).trim());
                        break;
                    }
                }
                constructor = ((Class)msg2).getConstructor(this.logConstructorSignature);
                Object o = constructor.newInstance(params);
                if (o instanceof Log) {
                    logAdapterClass = msg2;
                    logAdapter = (Log)o;
                    break;
                }
                this.handleFlawedHierarchy(currentCL, (Class)msg2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                msg2 = noClassDefFoundError;
                msg = noClassDefFoundError.getMessage();
                this.logDiagnostic("The log adapter '" + logAdapterClassName + "' is missing dependencies when loaded via classloader " + LogFactoryImpl.objectId(currentCL) + ": " + msg.trim());
                break;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                msg2 = exceptionInInitializerError;
                msg = exceptionInInitializerError.getMessage();
                this.logDiagnostic("The log adapter '" + logAdapterClassName + "' is unable to initialize itself when loaded via classloader " + LogFactoryImpl.objectId(currentCL) + ": " + msg.trim());
                break;
            }
            catch (LogConfigurationException logConfigurationException) {
                msg2 = logConfigurationException;
                throw logConfigurationException;
            }
            catch (Throwable throwable) {
                Throwable t = throwable;
                LogFactoryImpl.handleThrowable(throwable);
                this.handleFlawedDiscovery(logAdapterClassName, currentCL, t);
            }
            if (currentCL == null) break;
            currentCL = this.getParentClassLoader(currentCL);
        }
        if (logAdapterClass != null && var3_3 != false) {
            void var1_1;
            this.logClassName = logAdapterClassName;
            this.logConstructor = constructor;
            try {
                this.logMethod = logAdapterClass.getMethod("setLogFactory", this.logMethodSignature);
                this.logDiagnostic("Found method setLogFactory(LogFactory) in '" + logAdapterClassName + "'");
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                LogFactoryImpl.handleThrowable(throwable);
                this.logMethod = null;
                this.logDiagnostic("[INFO] '" + logAdapterClassName + "' from classloader " + LogFactoryImpl.objectId(currentCL) + " does not declare optional method setLogFactory(LogFactory)");
            }
            this.logDiagnostic("Log adapter '" + (String)var1_1 + "' from classloader " + LogFactoryImpl.objectId(logAdapterClass.getClassLoader()) + " has been selected for use.");
        }
        return logAdapter;
    }

    /*
     * WARNING - void declaration
     */
    private ClassLoader getBaseClassLoader() throws LogConfigurationException {
        void var1_1;
        void var2_2;
        ClassLoader thisClassLoader = LogFactoryImpl.getClassLoader(class$org$apache$commons$logging$impl$LogFactoryImpl == null ? (class$org$apache$commons$logging$impl$LogFactoryImpl = LogFactoryImpl.class$("com.github.igorsuhorukov.apache.commons.logging.impl.LogFactoryImpl")) : class$org$apache$commons$logging$impl$LogFactoryImpl);
        if (!this.useTCCL) {
            return thisClassLoader;
        }
        ClassLoader contextClassLoader = LogFactoryImpl.getContextClassLoaderInternal();
        ClassLoader baseClassLoader = this.getLowestClassLoader(contextClassLoader, thisClassLoader);
        if (baseClassLoader == null) {
            if (this.allowFlawedContext) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[WARNING] the context classloader is not part of a parent-child relationship with the classloader that loaded LogFactoryImpl.");
                }
                return contextClassLoader;
            }
            throw new LogConfigurationException("Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
        }
        if (baseClassLoader != var2_2) {
            if (this.allowFlawedContext) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Warning: the context classloader is an ancestor of the classloader that loaded LogFactoryImpl; it should be the same or a descendant. The application using commons-logging should ensure the context classloader is used correctly.");
                }
            } else {
                throw new LogConfigurationException("Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
            }
        }
        return var1_1;
    }

    private ClassLoader getLowestClassLoader(ClassLoader c1, ClassLoader c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        ClassLoader current = c1;
        while (current != null) {
            if (current == c2) {
                return c1;
            }
            current = this.getParentClassLoader(current);
        }
        current = c2;
        while (current != null) {
            if (current == c1) {
                return c2;
            }
            current = this.getParentClassLoader(current);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void handleFlawedDiscovery(String logAdapterClassName, ClassLoader classLoader, Throwable discoveryFlaw) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            Throwable cause;
            this.logDiagnostic("Could not instantiate Log '" + (String)logAdapterClassName + "' -- " + discoveryFlaw.getClass().getName() + ": " + discoveryFlaw.getLocalizedMessage());
            if (discoveryFlaw instanceof InvocationTargetException && (cause = ((InvocationTargetException)(logAdapterClassName = (InvocationTargetException)discoveryFlaw)).getTargetException()) != null) {
                Throwable cause2;
                this.logDiagnostic("... InvocationTargetException: " + cause.getClass().getName() + ": " + cause.getLocalizedMessage());
                if (cause instanceof ExceptionInInitializerError && (cause2 = ((ExceptionInInitializerError)(cause = (ExceptionInInitializerError)cause)).getException()) != null) {
                    void var2_2;
                    void var1_1;
                    StringWriter sw = new StringWriter();
                    var1_1.printStackTrace(new PrintWriter((Writer)sw, true));
                    this.logDiagnostic("... ExceptionInInitializerError: " + var2_2.toString());
                }
            }
        }
        if (!this.allowFlawedDiscovery) {
            void var3_3;
            throw new LogConfigurationException((Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleFlawedHierarchy(ClassLoader badClassLoader, Class badClass) throws LogConfigurationException {
        void var3_3;
        boolean implementsLog = false;
        String logInterfaceName = (class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName();
        Class<?>[] interfaces = badClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!logInterfaceName.equals(interfaces[i].getName())) continue;
            implementsLog = true;
            break;
        }
        if (var3_3 != false) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                try {
                    void var1_1;
                    ClassLoader logInterfaceClassLoader = LogFactoryImpl.getClassLoader(class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log);
                    this.logDiagnostic("Class '" + badClass.getName() + "' was found in classloader " + LogFactoryImpl.objectId(var1_1) + ". It is bound to a Log interface which is not the one loaded from classloader " + LogFactoryImpl.objectId(logInterfaceClassLoader));
                }
                catch (Throwable throwable) {
                    Throwable logInterfaceClassLoader = throwable;
                    LogFactoryImpl.handleThrowable(throwable);
                    this.logDiagnostic("Error while trying to output diagnostics about bad class '" + badClass + "'");
                }
            }
            if (!this.allowFlawedHierarchy) {
                StringBuffer msg = new StringBuffer();
                msg.append("Terminating logging for this context ");
                msg.append("due to bad log hierarchy. ");
                msg.append("You have more than one version of '");
                msg.append((class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName());
                msg.append("' visible.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(msg.toString());
                }
                throw new LogConfigurationException(msg.toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                StringBuffer msg = new StringBuffer();
                msg.append("Warning: bad log hierarchy. ");
                msg.append("You have more than one version of '");
                msg.append((class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName());
                msg.append("' visible.");
                this.logDiagnostic(msg.toString());
                return;
            }
        } else {
            if (!this.allowFlawedDiscovery) {
                StringBuffer msg = new StringBuffer();
                msg.append("Terminating logging for this context. ");
                msg.append("Log class '");
                msg.append(badClass.getName());
                msg.append("' does not implement the Log interface.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(msg.toString());
                }
                throw new LogConfigurationException(msg.toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                void var2_2;
                StringBuffer msg = new StringBuffer();
                msg.append("[WARNING] Log class '");
                msg.append(var2_2.getName());
                msg.append("' does not implement the Log interface.");
                this.logDiagnostic(msg.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            void var0_1;
            throw new NoClassDefFoundError(var0_1.getMessage());
        }
    }
}

