/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.commons.logging.impl;

import com.github.igorsuhorukov.apache.commons.logging.Log;
import com.github.igorsuhorukov.apache.commons.logging.LogConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class SimpleLog
implements Serializable,
Log {
    private static final long serialVersionUID = 136942970684951178L;
    protected static final String systemPrefix = "com.github.igorsuhorukov.apache.commons.logging.simplelog.";
    protected static final Properties simpleLogProps = new Properties();
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static volatile boolean showLogName = false;
    protected static volatile boolean showShortName = true;
    protected static volatile boolean showDateTime = false;
    protected static volatile String dateTimeFormat = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected volatile String logName = null;
    protected volatile int currentLogLevel;
    private volatile String shortLogName = null;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$commons$logging$impl$SimpleLog;

    /*
     * WARNING - void declaration
     */
    private static String getStringProperty(String name) {
        void var1_1;
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {}
        if (prop == null) {
            String string;
            return simpleLogProps.getProperty(string);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getStringProperty(String name, String dephault) {
        String string;
        String prop = SimpleLog.getStringProperty(name);
        if (prop == null) {
            void var1_1;
            return var1_1;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean getBooleanProperty(String name, boolean dephault) {
        String string;
        String prop = SimpleLog.getStringProperty(name);
        if (prop == null) {
            void var1_1;
            return (boolean)var1_1;
        }
        return "true".equalsIgnoreCase(string);
    }

    /*
     * WARNING - void declaration
     */
    public SimpleLog(String name) {
        void var2_2;
        this.logName = name;
        this.setLevel(3);
        String lvl = SimpleLog.getStringProperty("com.github.igorsuhorukov.apache.commons.logging.simplelog.log." + this.logName);
        int i = String.valueOf(name).lastIndexOf(".");
        while (lvl == null && i >= 0) {
            name = name.substring(0, i);
            lvl = SimpleLog.getStringProperty("com.github.igorsuhorukov.apache.commons.logging.simplelog.log." + name);
            i = String.valueOf(name).lastIndexOf(".");
        }
        if (lvl == null) {
            lvl = SimpleLog.getStringProperty("com.github.igorsuhorukov.apache.commons.logging.simplelog.defaultlog");
        }
        if ("all".equalsIgnoreCase(lvl)) {
            this.setLevel(0);
            return;
        }
        if ("trace".equalsIgnoreCase(lvl)) {
            this.setLevel(1);
            return;
        }
        if ("debug".equalsIgnoreCase(lvl)) {
            this.setLevel(2);
            return;
        }
        if ("info".equalsIgnoreCase(lvl)) {
            this.setLevel(3);
            return;
        }
        if ("warn".equalsIgnoreCase(lvl)) {
            this.setLevel(4);
            return;
        }
        if ("error".equalsIgnoreCase(lvl)) {
            this.setLevel(5);
            return;
        }
        if ("fatal".equalsIgnoreCase(lvl)) {
            this.setLevel(6);
            return;
        }
        if ("off".equalsIgnoreCase((String)var2_2)) {
            this.setLevel(7);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(int currentLogLevel) {
        void var1_1;
        this.currentLogLevel = var1_1;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void log(int type, Object message, Throwable t) {
        void var2_3;
        void var1_1;
        StringBuffer buf = new StringBuffer();
        if (showDateTime) {
            String dateText;
            Date now = new Date();
            DateFormat dateFormat = dateFormatter;
            synchronized (dateFormat) {
                dateText = dateFormatter.format(now);
            }
            buf.append(dateText);
            buf.append(" ");
        }
        switch (var1_1) {
            case 1: {
                buf.append("[TRACE] ");
                break;
            }
            case 2: {
                buf.append("[DEBUG] ");
                break;
            }
            case 3: {
                buf.append("[INFO] ");
                break;
            }
            case 4: {
                buf.append("[WARN] ");
                break;
            }
            case 5: {
                buf.append("[ERROR] ");
                break;
            }
            case 6: {
                buf.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.shortLogName == null) {
                String slName = this.logName.substring(this.logName.lastIndexOf(".") + 1);
                this.shortLogName = slName.substring(slName.lastIndexOf("/") + 1);
            }
            buf.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (showLogName) {
            buf.append(String.valueOf(this.logName)).append(" - ");
        }
        buf.append(String.valueOf(var2_3));
        if (t != null) {
            void var3_4;
            buf.append(" <");
            buf.append(t.toString());
            buf.append(">");
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(sw);
            var3_4.printStackTrace(pw);
            pw.close();
            buf.append(sw.toString());
        }
        this.write(buf);
    }

    /*
     * WARNING - void declaration
     */
    protected void write(StringBuffer buffer) {
        void var1_1;
        System.err.println(var1_1.toString());
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(Object message) {
        if (this.isLevelEnabled(2)) {
            void var1_1;
            this.log(2, var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void debug(Object message, Throwable t) {
        if (this.isLevelEnabled(2)) {
            void var2_2;
            void var1_1;
            this.log(2, var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(Object message) {
        if (this.isLevelEnabled(1)) {
            void var1_1;
            this.log(1, var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void trace(Object message, Throwable t) {
        if (this.isLevelEnabled(1)) {
            void var2_2;
            void var1_1;
            this.log(1, var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void info(Object message) {
        if (this.isLevelEnabled(3)) {
            void var1_1;
            this.log(3, var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void info(Object message, Throwable t) {
        if (this.isLevelEnabled(3)) {
            void var2_2;
            void var1_1;
            this.log(3, var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(Object message) {
        if (this.isLevelEnabled(4)) {
            void var1_1;
            this.log(4, var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void warn(Object message, Throwable t) {
        if (this.isLevelEnabled(4)) {
            void var2_2;
            void var1_1;
            this.log(4, var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void error(Object message) {
        if (this.isLevelEnabled(5)) {
            void var1_1;
            this.log(5, var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void error(Object message, Throwable t) {
        if (this.isLevelEnabled(5)) {
            void var2_2;
            void var1_1;
            this.log(5, var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void fatal(Object message) {
        if (this.isLevelEnabled(6)) {
            void var1_1;
            this.log(6, var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void fatal(Object message, Throwable t) {
        if (this.isLevelEnabled(6)) {
            void var2_2;
            void var1_1;
            this.log(6, var1_1, (Throwable)var2_2);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    /*
     * WARNING - void declaration
     */
    private static ClassLoader getContextClassLoader() {
        void var0;
        ClassLoader classLoader = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = SimpleLog.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException e = invocationTargetException;
                if (!(invocationTargetException.getTargetException() instanceof SecurityException)) {
                    void var1_1;
                    throw new LogConfigurationException("Unexpected InvocationTargetException", var1_1.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (classLoader == null) {
            classLoader = (class$org$apache$commons$logging$impl$SimpleLog == null ? (class$org$apache$commons$logging$impl$SimpleLog = SimpleLog.class$("com.github.igorsuhorukov.apache.commons.logging.impl.SimpleLog")) : class$org$apache$commons$logging$impl$SimpleLog).getClassLoader();
        }
        return var0;
    }

    private static InputStream getResourceAsStream(String name) {
        String string;
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - void declaration
             */
            public final Object run() {
                ClassLoader threadCL = SimpleLog.getContextClassLoader();
                if (threadCL != null) {
                    void var1_1;
                    return var1_1.getResourceAsStream(string);
                }
                return ClassLoader.getSystemResourceAsStream(string);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            void var0_1;
            throw new NoClassDefFoundError(var0_1.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        InputStream in = SimpleLog.getResourceAsStream("simplelog.properties");
        if (in != null) {
            try {
                void var0;
                simpleLogProps.load(in);
                var0.close();
            }
            catch (IOException iOException) {}
        }
        showLogName = SimpleLog.getBooleanProperty("com.github.igorsuhorukov.apache.commons.logging.simplelog.showlogname", showLogName);
        showShortName = SimpleLog.getBooleanProperty("com.github.igorsuhorukov.apache.commons.logging.simplelog.showShortLogname", showShortName);
        if (showDateTime = SimpleLog.getBooleanProperty("com.github.igorsuhorukov.apache.commons.logging.simplelog.showdatetime", showDateTime)) {
            dateTimeFormat = SimpleLog.getStringProperty("com.github.igorsuhorukov.apache.commons.logging.simplelog.dateTimeFormat", dateTimeFormat);
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }
}

