/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.commons.logging.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class WeakHashtable
extends Hashtable {
    private static final long serialVersionUID = -1546036869799732453L;
    private static final int MAX_CHANGES_BEFORE_PURGE = 100;
    private static final int PARTIAL_PURGE_COUNT = 10;
    private final ReferenceQueue queue = new ReferenceQueue();
    private int changeCount = 0;

    /*
     * WARNING - void declaration
     */
    public final boolean containsKey(Object key) {
        void var1_1;
        Referenced referenced = new Referenced(key, 0);
        return super.containsKey(var1_1);
    }

    public final Enumeration elements() {
        this.purge();
        return super.elements();
    }

    /*
     * WARNING - void declaration
     */
    public final Set entrySet() {
        void var2_2;
        this.purge();
        Set referencedEntries = super.entrySet();
        HashSet<void> unreferencedEntries = new HashSet<void>();
        Iterator it = referencedEntries.iterator();
        while (it.hasNext()) {
            void var3_3;
            Map.Entry entry = it.next();
            Referenced referenced = (Referenced)entry.getKey();
            Object key = Referenced.access$100(referenced);
            Object value = entry.getValue();
            if (key == null) continue;
            Entry dereferencedEntry = new Entry(key, value, 0);
            unreferencedEntries.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Object get(Object key) {
        void var1_1;
        Referenced referenceKey = new Referenced(key, 0);
        return super.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Enumeration keys() {
        void var1_1;
        this.purge();
        Enumeration enumer = super.keys();
        return new Enumeration(this, (Enumeration)var1_1){
            private final /* synthetic */ Enumeration val$enumer;
            {
                this.val$enumer = enumeration;
            }

            public final boolean hasMoreElements() {
                return this.val$enumer.hasMoreElements();
            }

            public final Object nextElement() {
                Referenced referenced = (Referenced)this.val$enumer.nextElement();
                return Referenced.access$100(referenced);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Set keySet() {
        void var2_2;
        this.purge();
        Set referencedKeys = super.keySet();
        HashSet<Referenced> unreferencedKeys = new HashSet<Referenced>();
        Iterator it = referencedKeys.iterator();
        while (it.hasNext()) {
            Referenced referenced = (Referenced)it.next();
            Object keyValue = Referenced.access$100(referenced);
            if (keyValue == null) continue;
            unreferencedKeys.add(referenced);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Object put(Object key, Object value) {
        void var2_2;
        void var1_1;
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        if (value == null) {
            throw new NullPointerException("Null values are not allowed");
        }
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        Referenced keyRef = new Referenced(key, this.queue, 0);
        return super.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void putAll(Map t) {
        if (t != null) {
            t = t.entrySet();
            Iterator it = t.iterator();
            while (it.hasNext()) {
                void var2_2;
                Map.Entry entry = it.next();
                this.put(entry.getKey(), var2_2.getValue());
            }
        }
    }

    public final Collection values() {
        this.purge();
        return super.values();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Object remove(Object key) {
        void var1_1;
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        return super.remove(new Referenced((Object)var1_1, 0));
    }

    public final boolean isEmpty() {
        this.purge();
        return super.isEmpty();
    }

    public final int size() {
        this.purge();
        return super.size();
    }

    public final String toString() {
        this.purge();
        return super.toString();
    }

    protected final void rehash() {
        this.purge();
        super.rehash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        ArrayList<Referenced> toRemove = new ArrayList<Referenced>();
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakKey key;
            while ((key = (WeakKey)this.queue.poll()) != null) {
                toRemove.add(WeakKey.access$400(key));
            }
        }
        int size = toRemove.size();
        for (int i = 0; i < size; ++i) {
            super.remove(toRemove.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void purgeOne() {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakKey key = (WeakKey)this.queue.poll();
            if (key != null) {
                void var2_2;
                super.remove(WeakKey.access$400((WeakKey)var2_2));
            }
            return;
        }
    }

    static final class WeakKey
    extends WeakReference {
        private final Referenced referenced;

        /*
         * WARNING - void declaration
         */
        private WeakKey(Object key, ReferenceQueue queue, Referenced referenced) {
            super(var1_1, var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.referenced = var3_3;
        }

        static /* synthetic */ Referenced access$400(WeakKey x0) {
            WeakKey weakKey = x0;
            return weakKey.referenced;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ WeakKey(Object x0, ReferenceQueue x1, Referenced x2, byte by) {
            this(var1_1, (ReferenceQueue)var2_2, (Referenced)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    static final class Referenced {
        private final WeakReference reference;
        private final int hashCode;

        /*
         * WARNING - void declaration
         */
        private Referenced(Object referant) {
            void var1_1;
            this.reference = new WeakReference<Object>(referant);
            this.hashCode = var1_1.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        private Referenced(Object key, ReferenceQueue queue) {
            void var1_1;
            void var2_2;
            this.reference = new WeakKey(key, (ReferenceQueue)var2_2, this, 0);
            this.hashCode = var1_1.hashCode();
        }

        public final int hashCode() {
            return this.hashCode;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            boolean bl;
            boolean result = false;
            if (o instanceof Referenced) {
                Referenced otherKey = (Referenced)o;
                Referenced referenced = this;
                Object thisKeyValue2 = referenced.reference.get();
                referenced = otherKey;
                Object otherKeyValue = referenced.reference.get();
                if (thisKeyValue2 == null) {
                    void var1_1;
                    boolean thisKeyValue2 = otherKeyValue == null;
                    thisKeyValue2 = thisKeyValue2 && this.hashCode() == var1_1.hashCode();
                } else {
                    void var2_3;
                    bl = var2_3.equals(referenced);
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Referenced(Object x0, byte by) {
            this(var1_1);
            void var1_1;
        }

        static /* synthetic */ Object access$100(Referenced x0) {
            Referenced referenced = x0;
            return referenced.reference.get();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Referenced(Object x0, ReferenceQueue x1, byte by) {
            this((Object)var1_1, (ReferenceQueue)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    static final class Entry
    implements Map.Entry {
        private final Object key;
        private final Object value;

        /*
         * WARNING - void declaration
         */
        private Entry(Object key, Object value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var2_2;
            boolean result = false;
            if (o != null && o instanceof Map.Entry) {
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                result = (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(var1_1.getValue()));
            }
            return (boolean)var2_2;
        }

        public final int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public final Object setValue(Object value) {
            throw new UnsupportedOperationException("Entry.setValue is not supported.");
        }

        public final Object getValue() {
            return this.value;
        }

        public final Object getKey() {
            return this.key;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Entry(Object x0, Object x1, byte by) {
            this(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

