/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.impl;

import com.github.igorsuhorukov.apache.http.annotation.NotThreadSafe;
import com.github.igorsuhorukov.apache.http.impl.SocketHttpServerConnection;
import com.github.igorsuhorukov.apache.http.params.HttpConnectionParams;
import com.github.igorsuhorukov.apache.http.params.HttpParams;
import java.io.IOException;
import java.net.Socket;

@NotThreadSafe
public class DefaultHttpServerConnection
extends SocketHttpServerConnection {
    public void bind(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        socket.setKeepAlive(HttpConnectionParams.getSoKeepalive(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        super.bind(socket, params);
    }
}

