/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.protocol;

import com.github.igorsuhorukov.apache.http.HttpEntity;
import com.github.igorsuhorukov.apache.http.HttpEntityEnclosingRequest;
import com.github.igorsuhorukov.apache.http.HttpException;
import com.github.igorsuhorukov.apache.http.HttpRequest;
import com.github.igorsuhorukov.apache.http.HttpRequestInterceptor;
import com.github.igorsuhorukov.apache.http.HttpVersion;
import com.github.igorsuhorukov.apache.http.ProtocolVersion;
import com.github.igorsuhorukov.apache.http.annotation.Immutable;
import com.github.igorsuhorukov.apache.http.params.HttpProtocolParams;
import com.github.igorsuhorukov.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntity entity;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && entity.getContentLength() != 0L) {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (HttpProtocolParams.useExpectContinue(request.getParams()) && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

