/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.http.protocol;

import com.github.igorsuhorukov.apache.http.HttpException;
import com.github.igorsuhorukov.apache.http.HttpRequest;
import com.github.igorsuhorukov.apache.http.HttpRequestInterceptor;
import com.github.igorsuhorukov.apache.http.annotation.Immutable;
import com.github.igorsuhorukov.apache.http.params.HttpProtocolParams;
import com.github.igorsuhorukov.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String useragent;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (!request.containsHeader("User-Agent") && (useragent = HttpProtocolParams.getUserAgent(request.getParams())) != null) {
            request.addHeader("User-Agent", useragent);
        }
    }
}

