/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.model;

import com.github.igorsuhorukov.apache.maven.model.InputLocation;
import com.github.igorsuhorukov.apache.maven.model.InputLocationTracker;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class RepositoryPolicy
implements Serializable,
Cloneable,
InputLocationTracker {
    private String enabled;
    private String updatePolicy;
    private String checksumPolicy;
    private Map<Object, InputLocation> locations;

    public RepositoryPolicy clone() {
        try {
            RepositoryPolicy copy = (RepositoryPolicy)super.clone();
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public String getEnabled() {
        return this.enabled;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setUpdatePolicy(String updatePolicy) {
        this.updatePolicy = updatePolicy;
    }

    public boolean isEnabled() {
        return this.enabled != null ? Boolean.parseBoolean(this.enabled) : true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = String.valueOf(enabled);
    }
}

