/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.model.composition;

import com.github.igorsuhorukov.apache.maven.model.Dependency;
import com.github.igorsuhorukov.apache.maven.model.DependencyManagement;
import com.github.igorsuhorukov.apache.maven.model.Model;
import com.github.igorsuhorukov.apache.maven.model.building.ModelBuildingRequest;
import com.github.igorsuhorukov.apache.maven.model.building.ModelProblemCollector;
import com.github.igorsuhorukov.apache.maven.model.composition.DependencyManagementImporter;
import com.github.igorsuhorukov.codehaus.plexus.component.annotations.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Component(role=DependencyManagementImporter.class)
public class DefaultDependencyManagementImporter
implements DependencyManagementImporter {
    @Override
    public void importManagement(Model target, List<? extends DependencyManagement> sources, ModelBuildingRequest request, ModelProblemCollector problems) {
        if (sources != null && !sources.isEmpty()) {
            LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
            DependencyManagement depMngt = target.getDependencyManagement();
            if (depMngt != null) {
                for (Dependency dependency : depMngt.getDependencies()) {
                    dependencies.put(dependency.getManagementKey(), dependency);
                }
            } else {
                depMngt = new DependencyManagement();
                target.setDependencyManagement(depMngt);
            }
            for (DependencyManagement dependencyManagement : sources) {
                for (Dependency dependency : dependencyManagement.getDependencies()) {
                    String key = dependency.getManagementKey();
                    if (dependencies.containsKey(key)) continue;
                    dependencies.put(key, dependency);
                }
            }
            depMngt.setDependencies(new ArrayList<Dependency>(dependencies.values()));
        }
    }
}

