/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.model.profile.activation;

import com.github.igorsuhorukov.apache.maven.model.Activation;
import com.github.igorsuhorukov.apache.maven.model.ActivationFile;
import com.github.igorsuhorukov.apache.maven.model.Profile;
import com.github.igorsuhorukov.apache.maven.model.building.ModelProblem;
import com.github.igorsuhorukov.apache.maven.model.building.ModelProblemCollector;
import com.github.igorsuhorukov.apache.maven.model.building.ModelProblemCollectorRequest;
import com.github.igorsuhorukov.apache.maven.model.path.PathTranslator;
import com.github.igorsuhorukov.apache.maven.model.profile.ProfileActivationContext;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.ProfileActivator;
import com.github.igorsuhorukov.codehaus.plexus.component.annotations.Component;
import com.github.igorsuhorukov.codehaus.plexus.component.annotations.Requirement;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.AbstractValueSource;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.MapBasedValueSource;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.RegexBasedInterpolator;
import com.github.igorsuhorukov.codehaus.plexus.util.StringUtils;
import java.io.File;

@Component(role=ProfileActivator.class, hint="file")
public class FileProfileActivator
implements ProfileActivator {
    @Requirement
    private PathTranslator pathTranslator;

    public FileProfileActivator setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean missing;
        String path;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        if (file == null) {
            return false;
        }
        if (StringUtils.isNotEmpty(file.getExists())) {
            path = file.getExists();
            missing = false;
        } else if (StringUtils.isNotEmpty(file.getMissing())) {
            path = file.getMissing();
            missing = true;
        } else {
            return false;
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        final File basedir = context.getProjectDirectory();
        if (basedir != null) {
            interpolator.addValueSource(new AbstractValueSource(false){

                @Override
                public Object getValue(String expression) {
                    if ("basedir".equals(expression)) {
                        return basedir.getAbsolutePath();
                    }
                    return null;
                }
            });
        } else if (path.contains("${basedir}")) {
            return false;
        }
        interpolator.addValueSource(new MapBasedValueSource(context.getProjectProperties()));
        interpolator.addValueSource(new MapBasedValueSource(context.getUserProperties()));
        interpolator.addValueSource(new MapBasedValueSource(context.getSystemProperties()));
        try {
            path = interpolator.interpolate(path, "");
        }
        catch (Exception e) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate file location " + path + " for profile " + profile.getId() + ": " + e.getMessage()).setLocation(file.getLocation(missing ? "missing" : "exists")).setException(e));
            return false;
        }
        path = this.pathTranslator.alignToBaseDirectory(path, basedir);
        if (missing) {
            file.setMissing(path);
        } else {
            file.setExists(path);
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            return false;
        }
        boolean fileExists = f.exists();
        return missing ? !fileExists : fileExists;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        return file != null;
    }
}

