/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.apache.maven.settings.io;

import com.github.igorsuhorukov.apache.maven.settings.Settings;
import com.github.igorsuhorukov.apache.maven.settings.io.SettingsWriter;
import com.github.igorsuhorukov.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import com.github.igorsuhorukov.codehaus.plexus.component.annotations.Component;
import com.github.igorsuhorukov.codehaus.plexus.util.IOUtil;
import com.github.igorsuhorukov.codehaus.plexus.util.WriterFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

@Component(role=SettingsWriter.class)
public class DefaultSettingsWriter
implements SettingsWriter {
    @Override
    public void write(File output, Map<String, Object> options, Settings settings) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output file missing");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings missing");
        }
        output.getParentFile().mkdirs();
        this.write(WriterFactory.newXmlWriter(output), options, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer output, Map<String, Object> options, Settings settings) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output writer missing");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings missing");
        }
        try {
            SettingsXpp3Writer w = new SettingsXpp3Writer();
            w.write(output, settings);
        }
        finally {
            IOUtil.close(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output, Map<String, Object> options, Settings settings) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output stream missing");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings missing");
        }
        try {
            String encoding = settings.getModelEncoding();
            if (encoding == null || encoding.length() <= 0) {
                encoding = "UTF-8";
            }
            this.write(new OutputStreamWriter(output, encoding), options, settings);
        }
        finally {
            IOUtil.close(output);
        }
    }
}

