/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.installation;

import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.eclipse.aether.installation.InstallRequest;
import com.github.igorsuhorukov.eclipse.aether.metadata.Metadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstallResult {
    private final InstallRequest request;
    private Collection<Artifact> artifacts;
    private Collection<Metadata> metadata;

    public InstallResult(InstallRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("install request has not been specified");
        }
        this.request = request;
        this.artifacts = Collections.emptyList();
        this.metadata = Collections.emptyList();
    }

    public InstallRequest getRequest() {
        return this.request;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public InstallResult setArtifacts(Collection<Artifact> artifacts) {
        this.artifacts = artifacts == null ? Collections.emptyList() : artifacts;
        return this;
    }

    public InstallResult addArtifact(Artifact artifact) {
        if (artifact != null) {
            if (this.artifacts.isEmpty()) {
                this.artifacts = new ArrayList<Artifact>();
            }
            this.artifacts.add(artifact);
        }
        return this;
    }

    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public InstallResult setMetadata(Collection<Metadata> metadata) {
        this.metadata = metadata == null ? Collections.emptyList() : metadata;
        return this;
    }

    public InstallResult addMetadata(Metadata metadata) {
        if (metadata != null) {
            if (this.metadata.isEmpty()) {
                this.metadata = new ArrayList<Metadata>();
            }
            this.metadata.add(metadata);
        }
        return this;
    }

    public String toString() {
        return this.getArtifacts() + ", " + this.getMetadata();
    }
}

