/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.internal.impl;

import com.github.igorsuhorukov.eclipse.aether.RepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.impl.RepositoryConnectorProvider;
import com.github.igorsuhorukov.eclipse.aether.internal.impl.PrioritizedComponent;
import com.github.igorsuhorukov.eclipse.aether.internal.impl.PrioritizedComponents;
import com.github.igorsuhorukov.eclipse.aether.internal.impl.Utils;
import com.github.igorsuhorukov.eclipse.aether.repository.Authentication;
import com.github.igorsuhorukov.eclipse.aether.repository.Proxy;
import com.github.igorsuhorukov.eclipse.aether.repository.RemoteRepository;
import com.github.igorsuhorukov.eclipse.aether.spi.connector.RepositoryConnector;
import com.github.igorsuhorukov.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.Service;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.ServiceLocator;
import com.github.igorsuhorukov.eclipse.aether.spi.log.Logger;
import com.github.igorsuhorukov.eclipse.aether.spi.log.LoggerFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.log.NullLoggerFactory;
import com.github.igorsuhorukov.eclipse.aether.transfer.NoRepositoryConnectorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultRepositoryConnectorProvider
implements RepositoryConnectorProvider,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private Collection<RepositoryConnectorFactory> connectorFactories = new ArrayList<RepositoryConnectorFactory>();

    public DefaultRepositoryConnectorProvider() {
    }

    @Inject
    DefaultRepositoryConnectorProvider(Set<RepositoryConnectorFactory> connectorFactories, LoggerFactory loggerFactory) {
        this.setRepositoryConnectorFactories(connectorFactories);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.connectorFactories = locator.getServices(RepositoryConnectorFactory.class);
    }

    public DefaultRepositoryConnectorProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultRepositoryConnectorProvider addRepositoryConnectorFactory(RepositoryConnectorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("repository connector factory has not been specified");
        }
        this.connectorFactories.add(factory);
        return this;
    }

    public DefaultRepositoryConnectorProvider setRepositoryConnectorFactories(Collection<RepositoryConnectorFactory> factories) {
        this.connectorFactories = factories == null ? new ArrayList<RepositoryConnectorFactory>() : factories;
        return this;
    }

    @Override
    public RepositoryConnector newRepositoryConnector(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        if (repository == null) {
            throw new IllegalArgumentException("remote repository has not been specified");
        }
        PrioritizedComponents<RepositoryConnectorFactory> factories = new PrioritizedComponents<RepositoryConnectorFactory>(session);
        for (RepositoryConnectorFactory factory : this.connectorFactories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoRepositoryConnectorException> errors = new ArrayList<NoRepositoryConnectorException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                RepositoryConnector repositoryConnector = ((RepositoryConnectorFactory)factory.getComponent()).newInstance(session, repository);
                if (this.logger.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(repositoryConnector.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, repositoryConnector);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    this.logger.debug(buffer.toString());
                }
                return repositoryConnector;
            }
            catch (NoRepositoryConnectorException noRepositoryConnectorException) {
                errors.add(noRepositoryConnectorException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain connector factory for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No connector factories available");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available connector factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryConnectorException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryConnectorException)errors.get(0) : null);
    }
}

