/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.internal.impl;

import com.github.igorsuhorukov.eclipse.aether.RepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.impl.UpdatePolicyAnalyzer;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.Service;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.ServiceLocator;
import com.github.igorsuhorukov.eclipse.aether.spi.log.Logger;
import com.github.igorsuhorukov.eclipse.aether.spi.log.LoggerFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.log.NullLoggerFactory;
import java.util.Calendar;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultUpdatePolicyAnalyzer
implements UpdatePolicyAnalyzer,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;

    public DefaultUpdatePolicyAnalyzer() {
    }

    @Inject
    DefaultUpdatePolicyAnalyzer(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public DefaultUpdatePolicyAnalyzer setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public String getEffectiveUpdatePolicy(RepositorySystemSession session, String policy1, String policy2) {
        return this.ordinalOfUpdatePolicy(policy1) < this.ordinalOfUpdatePolicy(policy2) ? policy1 : policy2;
    }

    private int ordinalOfUpdatePolicy(String policy) {
        if ("daily".equals(policy)) {
            return 1440;
        }
        if ("always".equals(policy)) {
            return 0;
        }
        if (policy != null && policy.startsWith("interval")) {
            return this.getMinutes(policy);
        }
        return Integer.MAX_VALUE;
    }

    public boolean isUpdatedRequired(RepositorySystemSession session, long lastModified, String policy) {
        boolean checkForUpdates;
        if (policy == null) {
            policy = "";
        }
        if ("always".equals(policy)) {
            checkForUpdates = true;
        } else if ("daily".equals(policy)) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            checkForUpdates = cal.getTimeInMillis() > lastModified;
        } else if (policy.startsWith("interval")) {
            int minutes = this.getMinutes(policy);
            Calendar cal = Calendar.getInstance();
            cal.add(12, -minutes);
            checkForUpdates = cal.getTimeInMillis() > lastModified;
        } else {
            checkForUpdates = false;
            if (!"never".equals(policy)) {
                this.logger.warn("Unknown repository update policy '" + policy + "', assuming '" + "never" + "'");
            }
        }
        return checkForUpdates;
    }

    private int getMinutes(String policy) {
        int minutes;
        try {
            String s = policy.substring("interval".length() + 1);
            minutes = Integer.valueOf(s);
        }
        catch (RuntimeException e) {
            minutes = 1440;
            this.logger.warn("Non-parseable repository update policy '" + policy + "', assuming '" + "interval" + ":1440'");
        }
        return minutes;
    }
}

