/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.resolution;

import com.github.igorsuhorukov.eclipse.aether.RequestTrace;
import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.eclipse.aether.repository.RemoteRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactDescriptorRequest {
    private Artifact artifact;
    private List<RemoteRepository> repositories = Collections.emptyList();
    private String context = "";
    private RequestTrace trace;

    public ArtifactDescriptorRequest() {
    }

    public ArtifactDescriptorRequest(Artifact artifact, List<RemoteRepository> repositories, String context) {
        this.setArtifact(artifact);
        this.setRepositories(repositories);
        this.setRequestContext(context);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactDescriptorRequest setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public ArtifactDescriptorRequest setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null ? Collections.emptyList() : repositories;
        return this;
    }

    public ArtifactDescriptorRequest addRepository(RemoteRepository repository) {
        if (repository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new ArrayList<RemoteRepository>();
            }
            this.repositories.add(repository);
        }
        return this;
    }

    public String getRequestContext() {
        return this.context;
    }

    public ArtifactDescriptorRequest setRequestContext(String context) {
        this.context = context != null ? context : "";
        return this;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public ArtifactDescriptorRequest setTrace(RequestTrace trace) {
        this.trace = trace;
        return this;
    }

    public String toString() {
        return this.getArtifact() + " < " + this.getRepositories();
    }
}

