/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.resolution;

import com.github.igorsuhorukov.eclipse.aether.RequestTrace;
import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.eclipse.aether.graph.DependencyNode;
import com.github.igorsuhorukov.eclipse.aether.repository.RemoteRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactRequest {
    private Artifact artifact;
    private DependencyNode node;
    private List<RemoteRepository> repositories = Collections.emptyList();
    private String context = "";
    private RequestTrace trace;

    public ArtifactRequest() {
    }

    public ArtifactRequest(Artifact artifact, List<RemoteRepository> repositories, String context) {
        this.setArtifact(artifact);
        this.setRepositories(repositories);
        this.setRequestContext(context);
    }

    public ArtifactRequest(DependencyNode node) {
        this.setDependencyNode(node);
        this.setRepositories(node.getRepositories());
        this.setRequestContext(node.getRequestContext());
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactRequest setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public DependencyNode getDependencyNode() {
        return this.node;
    }

    public ArtifactRequest setDependencyNode(DependencyNode node) {
        this.node = node;
        if (node != null) {
            this.setArtifact(node.getDependency().getArtifact());
        }
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public ArtifactRequest setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null ? Collections.emptyList() : repositories;
        return this;
    }

    public ArtifactRequest addRepository(RemoteRepository repository) {
        if (repository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new ArrayList<RemoteRepository>();
            }
            this.repositories.add(repository);
        }
        return this;
    }

    public String getRequestContext() {
        return this.context;
    }

    public ArtifactRequest setRequestContext(String context) {
        this.context = context != null ? context : "";
        return this;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public ArtifactRequest setTrace(RequestTrace trace) {
        this.trace = trace;
        return this;
    }

    public String toString() {
        return this.getArtifact() + " < " + this.getRepositories();
    }
}

