/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.transport.file;

import com.github.igorsuhorukov.eclipse.aether.RepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.repository.RemoteRepository;
import com.github.igorsuhorukov.eclipse.aether.spi.connector.transport.Transporter;
import com.github.igorsuhorukov.eclipse.aether.spi.connector.transport.TransporterFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.Service;
import com.github.igorsuhorukov.eclipse.aether.spi.locator.ServiceLocator;
import com.github.igorsuhorukov.eclipse.aether.spi.log.Logger;
import com.github.igorsuhorukov.eclipse.aether.spi.log.LoggerFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.log.NullLoggerFactory;
import com.github.igorsuhorukov.eclipse.aether.transfer.NoTransporterException;
import com.github.igorsuhorukov.eclipse.aether.transport.file.FileTransporter;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="file")
public final class FileTransporterFactory
implements TransporterFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority;

    public FileTransporterFactory() {
    }

    @Inject
    FileTransporterFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public FileTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, FileTransporter.class);
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public FileTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        return new FileTransporter(repository, this.logger);
    }
}

