/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.util.filter;

import com.github.igorsuhorukov.eclipse.aether.graph.DependencyFilter;
import com.github.igorsuhorukov.eclipse.aether.util.filter.AndDependencyFilter;
import com.github.igorsuhorukov.eclipse.aether.util.filter.NotDependencyFilter;
import com.github.igorsuhorukov.eclipse.aether.util.filter.OrDependencyFilter;
import com.github.igorsuhorukov.eclipse.aether.util.filter.ScopeDependencyFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyFilterUtils {
    private DependencyFilterUtils() {
    }

    public static DependencyFilter notFilter(DependencyFilter filter) {
        return new NotDependencyFilter(filter);
    }

    public static DependencyFilter andFilter(DependencyFilter ... filters) {
        if (filters != null && filters.length == 1) {
            return filters[0];
        }
        return new AndDependencyFilter(filters);
    }

    public static DependencyFilter andFilter(Collection<DependencyFilter> filters) {
        if (filters != null && filters.size() == 1) {
            return filters.iterator().next();
        }
        return new AndDependencyFilter(filters);
    }

    public static DependencyFilter orFilter(DependencyFilter ... filters) {
        if (filters != null && filters.length == 1) {
            return filters[0];
        }
        return new OrDependencyFilter(filters);
    }

    public static DependencyFilter orFilter(Collection<DependencyFilter> filters) {
        if (filters != null && filters.size() == 1) {
            return filters.iterator().next();
        }
        return new OrDependencyFilter(filters);
    }

    public static DependencyFilter classpathFilter(String ... classpathTypes) {
        return DependencyFilterUtils.classpathFilter(classpathTypes != null ? Arrays.asList(classpathTypes) : null);
    }

    public static DependencyFilter classpathFilter(Collection<String> classpathTypes) {
        HashSet<String> types = new HashSet<String>();
        if (classpathTypes != null) {
            for (String classpathType : classpathTypes) {
                String[] tokens;
                for (String token : tokens = classpathType.split("[+,]")) {
                    if ((token = token.trim()).length() <= 0) continue;
                    types.add(token);
                }
            }
        }
        HashSet<String> included = new HashSet<String>();
        for (String type : types) {
            if ("compile".equals(type)) {
                Collections.addAll(included, "compile", "provided", "system");
                continue;
            }
            if ("runtime".equals(type)) {
                Collections.addAll(included, "compile", "runtime");
                continue;
            }
            if ("test".equals(type)) {
                Collections.addAll(included, "compile", "provided", "system", "runtime", "test");
                continue;
            }
            included.add(type);
        }
        HashSet<String> excluded = new HashSet<String>();
        Collections.addAll(excluded, "compile", "provided", "system", "runtime", "test");
        excluded.removeAll(included);
        return new ScopeDependencyFilter(null, excluded);
    }
}

