/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.util.graph.selector;

import com.github.igorsuhorukov.eclipse.aether.collection.DependencyCollectionContext;
import com.github.igorsuhorukov.eclipse.aether.collection.DependencySelector;
import com.github.igorsuhorukov.eclipse.aether.graph.Dependency;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScopeDependencySelector
implements DependencySelector {
    private final boolean transitive;
    private final Collection<String> included;
    private final Collection<String> excluded;

    public ScopeDependencySelector(Collection<String> included, Collection<String> excluded) {
        this.transitive = false;
        this.included = ScopeDependencySelector.clone(included);
        this.excluded = ScopeDependencySelector.clone(excluded);
    }

    private static Collection<String> clone(Collection<String> scopes) {
        AbstractCollection copy;
        if (scopes == null || scopes.isEmpty()) {
            copy = null;
        } else {
            copy = new HashSet<String>(scopes);
            if (copy.size() <= 2) {
                copy = new ArrayList<String>(new TreeSet<String>(copy));
            }
        }
        return copy;
    }

    public ScopeDependencySelector(String ... excluded) {
        this(null, excluded != null ? Arrays.asList(excluded) : null);
    }

    private ScopeDependencySelector(boolean transitive, Collection<String> included, Collection<String> excluded) {
        this.transitive = transitive;
        this.included = included;
        this.excluded = excluded;
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        if (!this.transitive) {
            return true;
        }
        String scope = dependency.getScope();
        return !(this.included != null && !this.included.contains(scope) || this.excluded != null && this.excluded.contains(scope));
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.transitive || context.getDependency() == null) {
            return this;
        }
        return new ScopeDependencySelector(true, this.included, this.excluded);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencySelector that = (ScopeDependencySelector)obj;
        return this.transitive == that.transitive && ScopeDependencySelector.eq(this.included, that.included) && ScopeDependencySelector.eq(this.excluded, that.excluded);
    }

    private static <T> boolean eq(T o1, T o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.transitive ? 1 : 0);
        hash = hash * 31 + (this.included != null ? this.included.hashCode() : 0);
        hash = hash * 31 + (this.excluded != null ? this.excluded.hashCode() : 0);
        return hash;
    }
}

