/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.eclipse.aether.util.repository;

import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.eclipse.aether.repository.WorkspaceReader;
import com.github.igorsuhorukov.eclipse.aether.repository.WorkspaceRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChainedWorkspaceReader
implements WorkspaceReader {
    private List<WorkspaceReader> readers = new ArrayList<WorkspaceReader>();
    private WorkspaceRepository repository;

    public ChainedWorkspaceReader(WorkspaceReader ... readers) {
        if (readers != null) {
            Collections.addAll(this.readers, readers);
        }
        StringBuilder buffer = new StringBuilder();
        for (WorkspaceReader reader : this.readers) {
            if (buffer.length() > 0) {
                buffer.append('+');
            }
            buffer.append(reader.getRepository().getContentType());
        }
        this.repository = new WorkspaceRepository(buffer.toString(), new Key(this.readers));
    }

    public static WorkspaceReader newInstance(WorkspaceReader reader1, WorkspaceReader reader2) {
        if (reader1 == null) {
            return reader2;
        }
        if (reader2 == null) {
            return reader1;
        }
        return new ChainedWorkspaceReader(reader1, reader2);
    }

    @Override
    public File findArtifact(Artifact artifact) {
        WorkspaceReader reader;
        File file = null;
        Iterator<WorkspaceReader> i$ = this.readers.iterator();
        while (i$.hasNext() && (file = (reader = i$.next()).findArtifact(artifact)) == null) {
        }
        return file;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        LinkedHashSet<String> versions = new LinkedHashSet<String>();
        for (WorkspaceReader reader : this.readers) {
            versions.addAll(reader.findVersions(artifact));
        }
        return Collections.unmodifiableList(new ArrayList(versions));
    }

    @Override
    public WorkspaceRepository getRepository() {
        Key key = new Key(this.readers);
        if (!key.equals(this.repository.getKey())) {
            this.repository = new WorkspaceRepository(this.repository.getContentType(), key);
        }
        return this.repository;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key {
        private final List<Object> keys = new ArrayList<Object>();

        public Key(List<WorkspaceReader> readers) {
            for (WorkspaceReader reader : readers) {
                this.keys.add(reader.getRepository().getKey());
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return this.keys.equals(((Key)obj).keys);
        }

        public int hashCode() {
            return this.keys.hashCode();
        }
    }
}

