/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.base;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.CharMatcher;

public abstract class CaseFormat
extends Enum<CaseFormat> {
    public static final /* enum */ CaseFormat LOWER_HYPHEN = new CaseFormat(CharMatcher.is('-'), "-"){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String convert(CaseFormat format, String s) {
            void var2_2;
            void var1_1;
            if (format == LOWER_UNDERSCORE) {
                return s.replace('-', '_');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s.replace('-', '_'));
            }
            return super.convert((CaseFormat)var1_1, (String)var2_2);
        }
    };
    public static final /* enum */ CaseFormat LOWER_UNDERSCORE = new CaseFormat(CharMatcher.is('_'), "_"){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String convert(CaseFormat format, String s) {
            void var2_2;
            void var1_1;
            if (format == LOWER_HYPHEN) {
                return s.replace('_', '-');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s);
            }
            return super.convert((CaseFormat)var1_1, (String)var2_2);
        }
    };
    public static final /* enum */ CaseFormat LOWER_CAMEL = new CaseFormat(CharMatcher.inRange('A', 'Z'), ""){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return CaseFormat.access$100(word);
        }
    };
    private static /* enum */ CaseFormat UPPER_CAMEL = new CaseFormat(CharMatcher.inRange('A', 'Z'), ""){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return CaseFormat.access$100(word);
        }
    };
    public static final /* enum */ CaseFormat UPPER_UNDERSCORE = new CaseFormat(CharMatcher.is('_'), "_"){
        {
            void var3_3;
        }

        @Override
        final String normalizeWord(String word) {
            return Ascii.toUpperCase(word);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String convert(CaseFormat format, String s) {
            void var2_2;
            void var1_1;
            if (format == LOWER_HYPHEN) {
                return Ascii.toLowerCase(s.replace('_', '-'));
            }
            if (format == LOWER_UNDERSCORE) {
                return Ascii.toLowerCase(s);
            }
            return super.convert((CaseFormat)var1_1, (String)var2_2);
        }
    };
    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    /*
     * WARNING - void declaration
     */
    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        void var3_3;
        this.wordBoundary = var3_3;
        this.wordSeparator = wordSeparator;
    }

    /*
     * WARNING - void declaration
     */
    public final String to(CaseFormat format, String str) {
        void var2_2;
        void var1_1;
        Ascii.checkNotNull(format);
        Ascii.checkNotNull(str);
        if (format == this) {
            return str;
        }
        return this.convert((CaseFormat)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    String convert(CaseFormat format, String s) {
        void var2_2;
        void var1_1;
        void var3_3;
        StringBuilder out = null;
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = this.wordBoundary.indexIn(s, j)) == -1) break;
            if (i == 0) {
                out = new StringBuilder(s.length() + 4 * this.wordSeparator.length());
                out.append(format.normalizeFirstWord(s.substring(i, j)));
            } else {
                out.append(format.normalizeWord(s.substring(i, j)));
            }
            out.append(format.wordSeparator);
            i = j + this.wordSeparator.length();
        }
        if (i == 0) {
            return format.normalizeFirstWord(s);
        }
        return var3_3.append(var1_1.normalizeWord(var2_2.substring(i))).toString();
    }

    abstract String normalizeWord(String var1);

    /*
     * WARNING - void declaration
     */
    private String normalizeFirstWord(String word) {
        void var1_1;
        if (this == LOWER_CAMEL) {
            return Ascii.toLowerCase(word);
        }
        return this.normalizeWord((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ CaseFormat(String x0, int x1, CharMatcher x2, String x3, byte by) {
        this((CharMatcher)var3_3, x3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    static /* synthetic */ String access$100(String x0) {
        char c;
        String string = x0;
        if (string.isEmpty()) {
            return string;
        }
        return new StringBuilder(string.length()).append(Ascii.isLowerCase(c = string.charAt(0)) ? (char)(c & 0x5F) : c).append(Ascii.toLowerCase(string.substring(1))).toString();
    }

    static {
        CaseFormat[] caseFormatArray = new CaseFormat[]{LOWER_HYPHEN, LOWER_UNDERSCORE, LOWER_CAMEL, UPPER_CAMEL, UPPER_UNDERSCORE};
    }
}

