/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.base;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class Predicates {
    private static final Ascii COMMA_JOINER$7418a432 = Ascii.on$27f19060(',');

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        Predicate<T> predicate2;
        return new NotPredicate<T>(predicate2);
    }

    public static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> second) {
        Predicate<? super T> predicate;
        Predicate predicate2;
        predicate2 = (Predicate)Ascii.checkNotNull(predicate2);
        predicate = Ascii.checkNotNull(predicate);
        return new AndPredicate(Arrays.asList(predicate, predicate2), 0);
    }

    public static <T> Predicate<T> equalTo(@Nullable T target) {
        T t;
        if (target == null) {
            target = ObjectPredicate.IS_NULL;
            return target;
        }
        return new IsEqualToPredicate(t, 0);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        Class<?> clazz2;
        return new InstanceOfPredicate(clazz2, 0);
    }

    public static <T> Predicate<T> in(Collection<? extends T> target) {
        Collection<? extends T> collection;
        return new InPredicate(collection, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        void var1_1;
        Predicate<B> predicate2;
        return new CompositionPredicate(predicate2, (Function)var1_1, 0);
    }

    static final class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        private Predicate<B> p;
        private Function<A, ? extends B> f;

        /*
         * WARNING - void declaration
         */
        private CompositionPredicate(Predicate<B> p, Function<A, ? extends B> f) {
            void var2_2;
            void var1_1;
            this.p = (Predicate)Ascii.checkNotNull(var1_1);
            this.f = (Function)Ascii.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(@Nullable A a) {
            void var1_1;
            return this.p.apply(this.f.apply(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof CompositionPredicate) {
                void var1_1;
                CompositionPredicate that = (CompositionPredicate)obj;
                return this.f.equals(that.f) && this.p.equals(var1_1.p);
            }
            return false;
        }

        public final int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.p.toString()));
            String string2 = String.valueOf(String.valueOf(this.f.toString()));
            return new StringBuilder(2 + string.length() + string2.length()).append(string).append("(").append(string2).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ CompositionPredicate(Predicate x0, Function x1, byte by) {
            this((Predicate<B>)var1_1, (Function<A, B>)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    static final class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;

        /*
         * WARNING - void declaration
         */
        private InPredicate(Collection<?> target) {
            void var1_1;
            this.target = (Collection)Ascii.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(@Nullable T t) {
            try {
                void var1_1;
                return this.target.contains(var1_1);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof InPredicate) {
                void var1_1;
                InPredicate that = (InPredicate)obj;
                return this.target.equals(var1_1.target);
            }
            return false;
        }

        public final int hashCode() {
            return this.target.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.target));
            return new StringBuilder(15 + string.length()).append("Predicates.in(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ InPredicate(Collection x0, byte by) {
            this((Collection<?>)var1_1);
            void var1_1;
        }
    }

    static final class InstanceOfPredicate
    implements Predicate<Object>,
    Serializable {
        private final Class<?> clazz;

        /*
         * WARNING - void declaration
         */
        private InstanceOfPredicate(Class<?> clazz) {
            void var1_1;
            this.clazz = (Class)Ascii.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(@Nullable Object o) {
            void var1_1;
            return this.clazz.isInstance(var1_1);
        }

        public final int hashCode() {
            return this.clazz.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof InstanceOfPredicate) {
                void var1_1;
                InstanceOfPredicate that = (InstanceOfPredicate)obj;
                return this.clazz == var1_1.clazz;
            }
            return false;
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.clazz.getName()));
            return new StringBuilder(23 + string.length()).append("Predicates.instanceOf(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ InstanceOfPredicate(Class x0, byte by) {
            this((Class<?>)var1_1);
            void var1_1;
        }
    }

    static final class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;

        /*
         * WARNING - void declaration
         */
        private IsEqualToPredicate(T target) {
            void var1_1;
            this.target = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(T t) {
            void var1_1;
            return this.target.equals(var1_1);
        }

        public final int hashCode() {
            return this.target.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                void var1_1;
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(var1_1.target);
            }
            return false;
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.target));
            return new StringBuilder(20 + string.length()).append("Predicates.equalTo(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ IsEqualToPredicate(Object x0, byte by) {
            this(var1_1);
            void var1_1;
        }
    }

    static final class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> components;

        /*
         * WARNING - void declaration
         */
        private AndPredicate(List<? extends Predicate<? super T>> components) {
            void var1_1;
            this.components = var1_1;
        }

        @Override
        public final boolean apply(@Nullable T t) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (this.components.get(i).apply(t)) continue;
                return false;
            }
            return true;
        }

        public final int hashCode() {
            return this.components.hashCode() + 306654252;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof AndPredicate) {
                void var1_1;
                AndPredicate that = (AndPredicate)obj;
                return this.components.equals(var1_1.components);
            }
            return false;
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(COMMA_JOINER$7418a432.join(this.components)));
            return new StringBuilder(16 + string.length()).append("Predicates.and(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ AndPredicate(List x0, byte by) {
            this((List<Predicate<T>>)var1_1);
            void var1_1;
        }
    }

    static final class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private Predicate<T> predicate;

        /*
         * WARNING - void declaration
         */
        NotPredicate(Predicate<T> predicate) {
            void var1_1;
            this.predicate = (Predicate)Ascii.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(@Nullable T t) {
            void var1_1;
            return !this.predicate.apply(var1_1);
        }

        public final int hashCode() {
            return ~this.predicate.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof NotPredicate) {
                void var1_1;
                NotPredicate that = (NotPredicate)obj;
                return this.predicate.equals(var1_1.predicate);
            }
            return false;
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.predicate.toString()));
            return new StringBuilder(16 + string.length()).append("Predicates.not(").append(string).append(")").toString();
        }
    }

    static abstract class ObjectPredicate
    extends Enum<ObjectPredicate>
    implements Predicate<Object> {
        private static /* enum */ ObjectPredicate ALWAYS_TRUE = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return true;
            }

            public final String toString() {
                return "Predicates.alwaysTrue()";
            }
        };
        private static /* enum */ ObjectPredicate ALWAYS_FALSE = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return false;
            }

            public final String toString() {
                return "Predicates.alwaysFalse()";
            }
        };
        public static final /* enum */ ObjectPredicate IS_NULL = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return o == null;
            }

            public final String toString() {
                return "Predicates.isNull()";
            }
        };
        private static /* enum */ ObjectPredicate NOT_NULL = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return o != null;
            }

            public final String toString() {
                return "Predicates.notNull()";
            }
        };

        private ObjectPredicate() {
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ObjectPredicate(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            ObjectPredicate[] objectPredicateArray = new ObjectPredicate[]{ALWAYS_TRUE, ALWAYS_FALSE, IS_NULL, NOT_NULL};
        }
    }
}

