/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.base;

import com.github.igorsuhorukov.google.common.base.AbstractIterator;
import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.CharMatcher;
import java.util.Iterator;
import javax.annotation.CheckReturnValue;

public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final int limit;

    /*
     * WARNING - void declaration
     */
    private Splitter(Strategy strategy) {
        this((Strategy)var1_1, false, CharMatcher.NONE, Integer.MAX_VALUE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer, int limit) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.strategy = var1_1;
        this.omitEmptyStrings = var2_2;
        this.trimmer = var3_3;
        this.limit = limit;
    }

    public static Splitter on(char separator) {
        return Splitter.on(CharMatcher.is(separator));
    }

    public static Splitter on(CharMatcher separatorMatcher) {
        CharMatcher charMatcher;
        Ascii.checkNotNull(separatorMatcher);
        return new Splitter(new Strategy(){});
    }

    @CheckReturnValue
    public final Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    @CheckReturnValue
    public final Splitter trimResults() {
        CharMatcher charMatcher = CharMatcher.WHITESPACE;
        Splitter splitter = this;
        Ascii.checkNotNull(charMatcher);
        return new Splitter(splitter.strategy, splitter.omitEmptyStrings, charMatcher, splitter.limit);
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<String> split(CharSequence sequence) {
        void var1_1;
        Ascii.checkNotNull(sequence);
        return new Iterable<String>(this, (CharSequence)var1_1){
            private /* synthetic */ CharSequence val$sequence;
            private /* synthetic */ Splitter this$0;
            {
                this.this$0 = splitter;
                this.val$sequence = charSequence;
            }

            @Override
            public final Iterator<String> iterator() {
                return Splitter.access$000(this.this$0, this.val$sequence);
            }

            public final String toString() {
                return Ascii.on$7c648049(", ").appendTo(new StringBuilder("["), this).append(']').toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Iterator access$000(Splitter x0, CharSequence x1) {
        void var1_1;
        Splitter splitter = x0;
        return splitter.strategy.iterator(splitter, (CharSequence)var1_1);
    }

    static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        private CharMatcher trimmer;
        private boolean omitEmptyStrings;
        private int offset = 0;
        private int limit;

        abstract int separatorStart(int var1);

        abstract int separatorEnd(int var1);

        /*
         * WARNING - void declaration
         */
        protected SplittingIterator(Splitter splitter, CharSequence toSplit) {
            void var2_2;
            void var1_1;
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.limit = ((Splitter)var1_1).limit;
            this.toSplit = var2_2;
        }
    }

    static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }
}

