/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.collect.BiMap;
import com.github.igorsuhorukov.google.common.collect.Collections2;
import com.github.igorsuhorukov.google.common.collect.ForwardingMap;
import com.github.igorsuhorukov.google.common.collect.ForwardingSet;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.collect.Multiset;
import com.github.igorsuhorukov.google.common.collect.ObjectArrays;
import com.github.igorsuhorukov.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractBiMap<K, V>
extends ForwardingMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient Set<K> keySet;
    private transient Set<V> valueSet;
    private transient Set<Map.Entry<K, V>> entrySet;

    @Override
    protected final Map<K, V> delegate() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(@Nullable Object value) {
        void var1_1;
        return ((ForwardingMap)null).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(@Nullable K key, @Nullable V value) {
        void var1_1;
        void var2_4;
        boolean bl = false;
        void var3_5 = var2_4;
        AbstractBiMap abstractBiMap = this;
        var2_4 = var1_1;
        boolean bl2 = abstractBiMap.containsKey(var2_4);
        if (bl2 && Ascii.equal(var3_5, abstractBiMap.get(var2_4))) {
            return var3_5;
        }
        Ascii.checkArgument(!abstractBiMap.containsValue(var3_5), "value already present: %s", var3_5);
        void var5_7 = ((Map)null).put(var2_4, var3_5);
        abstractBiMap.updateInverseMap(var2_4, bl2, var5_7, var3_5);
        return var5_7;
    }

    /*
     * WARNING - void declaration
     */
    private void updateInverseMap(K key, boolean containedKey, V oldValue, V newValue) {
        void var1_1;
        if (containedKey) {
            void var3_3;
            this.removeFromInverseMap(var3_3);
        }
        ((Map)null).put(newValue, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(@Nullable Object key) {
        if (this.containsKey(key)) {
            void var1_1;
            return this.removeFromBothMaps(var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private V removeFromBothMaps(Object key) {
        void var1_1;
        Object oldValue = ((Map)null).remove(key);
        this.removeFromInverseMap(oldValue);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void removeFromInverseMap(V oldValue) {
        void var1_1;
        ((Map)null).remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            void var2_2;
            this.put(entry.getKey(), var2_2.getValue());
        }
    }

    @Override
    public void clear() {
        ((Map)null).clear();
        ((Map)null).clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> keySet() {
        void var1_1;
        Set<K> result = this.keySet;
        if (result == null) {
            this.keySet = new KeySet(this, 0);
            return this.keySet;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        void var1_1;
        Set<Map.Entry<K, V>> result = this.entrySet;
        if (result == null) {
            this.entrySet = new EntrySet(0);
            return this.entrySet;
        }
        return var1_1;
    }

    static /* synthetic */ Map access$200(AbstractBiMap x0) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$300(AbstractBiMap x0, Object x1) {
        void var1_1;
        return x0.removeFromBothMaps(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(AbstractBiMap x0, Object x1, boolean x2, Object x3, Object x4) {
        void var3_3;
        void var1_1;
        x0.updateInverseMap(var1_1, true, var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(AbstractBiMap x0, Object x1) {
        void var1_1;
        x0.removeFromInverseMap(var1_1);
    }

    public static class 1
    implements Function<Object, Object> {
        final /* synthetic */ Collection val$collection;

        /*
         * WARNING - void declaration
         */
        static void checkEntryNotNull(Object key, Object value) {
            void var1_1;
            if (key == null) {
                key = String.valueOf(String.valueOf(value));
                throw new NullPointerException(new StringBuilder(24 + ((String)key).length()).append("null key in entry: null=").append((String)key).toString());
            }
            if (var1_1 == null) {
                Object object;
                object = String.valueOf(String.valueOf(object));
                throw new NullPointerException(new StringBuilder(26 + ((String)object).length()).append("null value in entry: ").append((String)object).append("=null").toString());
            }
        }

        static int checkNonnegative(int value, String name) {
            int n;
            if (value < 0) {
                String string;
                string = String.valueOf(String.valueOf(string));
                throw new IllegalArgumentException(new StringBuilder(40 + string.length()).append(string).append(" cannot be negative but was: ").append(value).toString());
            }
            return n;
        }

        1(Collection collection) {
            this.val$collection = collection;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object apply(Object input) {
            void var1_1;
            if (input == this.val$collection) {
                return "(this Collection)";
            }
            return var1_1;
        }

        static int computeArrayListCapacity(int arraySize) {
            int n;
            1.checkNonnegative(arraySize, "arraySize");
            return Ints.saturatedCast(5L + (long)arraySize + (long)(n / 10));
        }

        /*
         * WARNING - void declaration
         */
        public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
            void var1_1;
            Iterator<? extends E> iterator;
            ArrayList list = new ArrayList();
            Iterators.addAll(list, iterator);
            return var1_1;
        }

        public static <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
            int n;
            return new ArrayList(1.computeArrayListCapacity(n));
        }

        /*
         * WARNING - void declaration
         */
        static int hashCodeImpl(Set<?> s) {
            void var1_1;
            int hashCode = 0;
            for (Object o : s) {
                void var2_2;
                hashCode += o != null ? var2_2.hashCode() : 0;
                hashCode = ~(~hashCode);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static boolean equalsImpl(Set<?> s, Object object) {
            if (s == object) {
                return true;
            }
            if (object instanceof Set) {
                Set o = (Set)object;
                try {
                    void var1_1;
                    Set<?> set;
                    return s.size() == o.size() && set.containsAll((Collection<?>)var1_1);
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
            void var2_2;
            boolean changed = false;
            while (iterator.hasNext()) {
                changed |= set.remove(iterator.next());
            }
            return (boolean)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
            void var1_1;
            Set<?> set2;
            Ascii.checkNotNull(collection);
            if (collection instanceof Multiset) {
                collection = ((Multiset)collection).elementSet();
            }
            if (collection instanceof Set && collection.size() > set.size()) {
                return Iterators.removeAll(set.iterator(), collection);
            }
            return 1.removeAllImpl(set2, var1_1.iterator());
        }

        static /* synthetic */ Object access$000(Multiset.Entry x0) {
            Multiset.Entry entry = x0;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getElement();
        }

        static /* synthetic */ Object access$100(Multiset.Entry x0) {
            Multiset.Entry entry = x0;
            if (entry == null) {
                return null;
            }
            return entry.getElement();
        }
    }

    final class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        private Set<Map.Entry<K, V>> esDelegate;

        private EntrySet() {
            this.esDelegate = AbstractBiMap.access$200(AbstractBiMap.this).entrySet();
        }

        @Override
        protected final Set<Map.Entry<K, V>> delegate() {
            return this.esDelegate;
        }

        @Override
        public final void clear() {
            AbstractBiMap.this.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object object) {
            void var1_1;
            if (!this.esDelegate.contains(object)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            AbstractBiMap.access$200(null).remove(entry.getValue());
            this.esDelegate.remove(var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            void var1_1;
            Iterator iterator = this.esDelegate.iterator();
            return new Iterator<Map.Entry<K, V>>((Iterator)var1_1){
                private Map.Entry<K, V> entry;
                private /* synthetic */ Iterator val$iterator;
                {
                    this.val$iterator = iterator;
                }

                @Override
                public final boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void remove() {
                    void var1_2;
                    boolean bl = this.entry != null;
                    Ascii.checkState(bl, "no calls to next() since the last call to remove()");
                    Object value = this.entry.getValue();
                    this.val$iterator.remove();
                    AbstractBiMap.access$700(AbstractBiMap.this, var1_2);
                }
            };
        }

        @Override
        public final Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public final <T> T[] toArray(T[] array) {
            EntrySet entrySet;
            void var2_2 = entrySet;
            entrySet = this;
            return ObjectArrays.toArrayImpl(entrySet, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            EntrySet entrySet = this;
            return Maps.containsEntryImpl(entrySet.esDelegate, var1_1);
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            EntrySet entrySet;
            void var2_2 = entrySet;
            entrySet = this;
            return Collections2.containsAllImpl(entrySet, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<?> c) {
            void var1_1;
            return this.standardRemoveAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<?> c) {
            void var1_1;
            return this.standardRetainAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntrySet(byte by) {
            this();
            void var1_1;
        }
    }

    final class ValueSet
    extends ForwardingSet<V> {
        private Set<V> valuesDelegate = ((AbstractBiMap)null).keySet();
        private /* synthetic */ AbstractBiMap this$0;

        private ValueSet(AbstractBiMap abstractBiMap) {
            this.this$0 = abstractBiMap;
        }

        @Override
        protected final Set<V> delegate() {
            return this.valuesDelegate;
        }

        @Override
        public final Iterator<V> iterator() {
            return Maps.valueIterator(this.this$0.entrySet().iterator());
        }

        @Override
        public final Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public final <T> T[] toArray(T[] array) {
            ValueSet valueSet;
            void var2_2 = valueSet;
            valueSet = this;
            return ObjectArrays.toArrayImpl(valueSet, var2_2);
        }

        @Override
        public final String toString() {
            return this.standardToString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ValueSet(AbstractBiMap x0, byte by) {
            this((AbstractBiMap)var1_1);
            void var1_1;
        }
    }

    final class KeySet
    extends ForwardingSet<K> {
        private /* synthetic */ AbstractBiMap this$0;

        private KeySet(AbstractBiMap abstractBiMap) {
            this.this$0 = abstractBiMap;
        }

        @Override
        protected final Set<K> delegate() {
            return AbstractBiMap.access$200(this.this$0).keySet();
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object key) {
            void var1_1;
            if (!this.contains(key)) {
                return false;
            }
            AbstractBiMap.access$300(this.this$0, var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<?> keysToRemove) {
            void var1_1;
            return this.standardRemoveAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<?> keysToRetain) {
            void var1_1;
            return this.standardRetainAll((Collection<?>)var1_1);
        }

        @Override
        public final Iterator<K> iterator() {
            return Maps.keyIterator(this.this$0.entrySet().iterator());
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ KeySet(AbstractBiMap x0, byte by) {
            this((AbstractBiMap)var1_1);
            void var1_1;
        }
    }
}

