/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.AbstractBiMap;
import com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap;
import com.github.igorsuhorukov.google.common.collect.AbstractMultimap;
import com.github.igorsuhorukov.google.common.collect.Collections2;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Maps;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;

abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private transient int totalSize;

    abstract Collection<V> createCollection();

    @Override
    public final int size() {
        return this.totalSize;
    }

    @Override
    public final void clear() {
        for (Collection collection : ((Map)null).values()) {
            collection.clear();
        }
        ((Map)null).clear();
        this.totalSize = 0;
    }

    /*
     * WARNING - void declaration
     */
    final Collection<V> wrapCollection(@Nullable K key, Collection<V> collection) {
        void var2_2;
        void var1_1;
        if (collection instanceof SortedSet) {
            return new WrappedSortedSet(this, key, (SortedSet)collection, null);
        }
        if (collection instanceof Set) {
            return new WrappedSet(this, key, (Set)collection);
        }
        if (collection instanceof List) {
            return this.wrapList(key, (List)collection, null);
        }
        return new WrappedCollection(this, (Object)var1_1, (Collection)var2_2, null);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    private List wrapList(@Nullable Object key, List list, @Nullable WrappedCollection ancestor) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (list instanceof RandomAccess) {
            return new RandomAccessWrappedList(this, key, list, ancestor);
        }
        return new WrappedList(this, (Object)var1_1, (List)var2_2, (WrappedCollection)var3_3);
    }

    @Override
    final Set<K> createKeySet() {
        return new KeySet(null);
    }

    @Override
    final Map<K, Collection<V>> createAsMap() {
        return new AsMap(null);
    }

    static /* synthetic */ Map access$000(AbstractMapBasedMultimap x0) {
        return null;
    }

    static /* synthetic */ Iterator access$100(AbstractMapBasedMultimap x0, Collection x1) {
        Collection collection = x1;
        if (collection instanceof List) {
            return ((List)collection).listIterator();
        }
        return collection.iterator();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$212(AbstractMapBasedMultimap x0, int x1) {
        void var1_1;
        return x0.totalSize += var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$220(AbstractMapBasedMultimap x0, int x1) {
        void var1_1;
        return x0.totalSize -= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$300(AbstractMapBasedMultimap x0, Object x1, List x2, WrappedCollection x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.wrapList(var1_1, (List)var2_2, (WrappedCollection)var3_3);
    }

    static /* synthetic */ int access$400(AbstractMapBasedMultimap x0, Object x1) {
        Collection collection;
        AbstractMapBasedMultimap abstractMapBasedMultimap = x0;
        collection = (Collection)Maps.safeRemove(null, collection);
        int n = 0;
        if (collection != null) {
            n = collection.size();
            collection.clear();
            abstractMapBasedMultimap.totalSize -= n;
        }
        return n;
    }

    class AsMap
    extends Maps.ImprovedAbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;

        /*
         * WARNING - void declaration
         */
        AsMap(Map<K, Collection<V>> submap) {
            void var2_2;
            this.submap = var2_2;
        }

        @Override
        protected final Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new AsMapEntries(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return Maps.safeContainsKey(this.submap, var1_1);
        }

        @Override
        public Set<K> keySet() {
            return AbstractMapBasedMultimap.this.keySet();
        }

        @Override
        public int size() {
            return this.submap.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(@Nullable Object object) {
            void var1_1;
            return this == object || this.submap.equals(var1_1);
        }

        @Override
        public int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        @Override
        public void clear() {
            if (this.submap == AbstractMapBasedMultimap.access$000(AbstractMapBasedMultimap.this)) {
                AbstractMapBasedMultimap.this.clear();
                return;
            }
            Iterators.clear(new AsMapIterator(this));
        }

        final class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            private Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            private Collection<V> collection;
            private /* synthetic */ AsMap this$1;

            AsMapIterator(AsMap asMap) {
                this.this$1 = asMap;
                this.delegateIterator = this.this$1.submap.entrySet().iterator();
            }

            @Override
            public final boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public final void remove() {
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.access$220(this.this$1.AbstractMapBasedMultimap.this, this.collection.size());
                this.collection.clear();
            }
        }

        final class AsMapEntries
        extends Maps.EntrySet<K, Collection<V>> {
            private /* synthetic */ AsMap this$1;

            AsMapEntries(AsMap asMap) {
                this.this$1 = asMap;
            }

            @Override
            final Map<K, Collection<V>> map() {
                return this.this$1;
            }

            @Override
            public final Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator(this.this$1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean contains(Object o) {
                void var1_1;
                return Collections2.safeContains(this.this$1.submap.entrySet(), var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean remove(Object o) {
                void var1_1;
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                AbstractMapBasedMultimap.access$400(this.this$1.AbstractMapBasedMultimap.this, var1_1.getKey());
                return true;
            }
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        private Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        private K key;
        private Collection<V> collection;
        private Iterator<V> valueIterator;
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        abstract T output$4e55edb();

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext() || this.valueIterator.hasNext();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            if (!this.valueIterator.hasNext()) {
                void var1_1;
                Map.Entry mapEntry = this.keyIterator.next();
                this.key = mapEntry.getKey();
                this.collection = (Collection)var1_1.getValue();
                this.valueIterator = this.collection.iterator();
            }
            this.valueIterator.next();
            return this.output$4e55edb();
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (this.collection.isEmpty()) {
                this.keyIterator.remove();
            }
            this.this$0.totalSize--;
        }
    }

    class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        /*
         * WARNING - void declaration
         */
        KeySet(Map<K, Collection<V>> subMap) {
            void var2_2;
            super(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<K> iterator() {
            void var1_1;
            Iterator entryIterator = this.map().entrySet().iterator();
            return new Iterator<K>(this, (Iterator)var1_1){
                private Map.Entry<K, Collection<V>> entry;
                private /* synthetic */ Iterator val$entryIterator;
                private /* synthetic */ KeySet this$1;
                {
                    this.this$1 = keySet;
                    this.val$entryIterator = iterator;
                }

                @Override
                public final boolean hasNext() {
                    return this.val$entryIterator.hasNext();
                }

                @Override
                public final K next() {
                    this.entry = (Map.Entry)this.val$entryIterator.next();
                    return this.entry.getKey();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void remove() {
                    void var1_2;
                    boolean bl = this.entry != null;
                    Ascii.checkState(bl, "no calls to next() since the last call to remove()");
                    Collection collection = this.entry.getValue();
                    this.val$entryIterator.remove();
                    AbstractMapBasedMultimap.access$220(this.this$1.AbstractMapBasedMultimap.this, collection.size());
                    var1_2.clear();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object key) {
            void var2_2;
            int count = 0;
            Collection collection = (Collection)this.map().remove(key);
            if (collection != null) {
                void var1_1;
                count = collection.size();
                var1_1.clear();
                AbstractMapBasedMultimap.access$220(AbstractMapBasedMultimap.this, count);
            }
            return var2_2 > 0;
        }

        @Override
        public void clear() {
            Iterators.clear(this.iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            return this.map().keySet().containsAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(@Nullable Object object) {
            void var1_1;
            return this == object || this.map().keySet().equals(var1_1);
        }

        @Override
        public int hashCode() {
            return this.map().keySet().hashCode();
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$com.google.common.collect.AbstractMapBasedMultimap$WrappedList, not com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$WrappedList - discarding signature.
     */
    final class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        /*
         * WARNING - void declaration
         */
        RandomAccessWrappedList(@Nullable K key, List<V> delegate, @Nullable AbstractMapBasedMultimap.WrappedCollection ancestor) {
            super((AbstractMapBasedMultimap)var1_1, (Object)var2_2, (List)var3_3, (WrappedCollection)ancestor);
            void var3_3;
            void var2_2;
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection, not com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$WrappedCollection - discarding signature.
     */
    static class WrappedList
    extends WrappedCollection
    implements List {
        final /* synthetic */ AbstractMapBasedMultimap this$0;

        /*
         * WARNING - void declaration
         */
        WrappedList(@Nullable K key, List<V> delegate, @Nullable AbstractMapBasedMultimap.WrappedCollection ancestor) {
            void var3_3;
            void var2_2;
            this.this$0 = var1_1;
            super((AbstractMapBasedMultimap)var1_1, (Object)var2_2, (Collection)var3_3, (WrappedCollection)ancestor);
        }

        final List<V> getListDelegate() {
            WrappedList wrappedList = this;
            return (List)wrappedList.delegate;
        }

        /*
         * WARNING - void declaration
         */
        public boolean addAll(int index, Collection<? extends V> c) {
            void var1_1;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.getListDelegate().addAll(index, c);
            if (changed) {
                void var3_4;
                void var2_3;
                c = this;
                int newSize = c.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var2_3 - oldSize));
                if (var3_4 == false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public V get(int index) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().get((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public V set(int index, V element) {
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().set((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void add(int index, V element) {
            void var3_4;
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            WrappedList wrappedList = this;
            boolean wasEmpty = wrappedList.delegate.isEmpty();
            this.getListDelegate().add((int)var1_1, var2_2);
            this.this$0.totalSize++;
            if (var3_4 != false) {
                this.addToMap();
            }
        }

        /*
         * WARNING - void declaration
         */
        public V remove(int index) {
            void var1_2;
            this.refreshIfEmpty();
            Object value = this.getListDelegate().remove(index);
            this.this$0.totalSize--;
            this.removeIfEmpty();
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(var1_1);
        }

        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator(this);
        }

        /*
         * WARNING - void declaration
         */
        public ListIterator<V> listIterator(int index) {
            void var1_1;
            this.refreshIfEmpty();
            return new WrappedListIterator(this, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public List<V> subList(int fromIndex, int toIndex) {
            WrappedList wrappedList;
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            WrappedList wrappedList2 = this;
            Object k = wrappedList2.key;
            List list = this.getListDelegate().subList((int)var1_1, (int)var2_2);
            wrappedList2 = this;
            if (wrappedList2.ancestor == null) {
                wrappedList = this;
            } else {
                wrappedList2 = this;
                wrappedList = wrappedList2.ancestor;
            }
            return AbstractMapBasedMultimap.access$300(this.this$0, k, list, wrappedList);
        }

        /*
         * Signature claims super is com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection.com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection$WrappedIterator, not com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$WrappedCollection$WrappedIterator - discarding signature.
         */
        final class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            private /* synthetic */ WrappedList this$1;

            WrappedListIterator(WrappedList wrappedList) {
                this.this$1 = wrappedList;
                super(wrappedList);
            }

            /*
             * WARNING - void declaration
             */
            public WrappedListIterator(WrappedList wrappedList, int index) {
                void var2_2;
                this.this$1 = wrappedList;
                super(wrappedList, wrappedList.getListDelegate().listIterator((int)var2_2));
            }

            private ListIterator<V> getDelegateListIterator() {
                WrappedListIterator wrappedListIterator = this;
                wrappedListIterator.validateIterator();
                return (ListIterator)wrappedListIterator.delegateIterator;
            }

            @Override
            public final boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            public final V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public final int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public final int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            /*
             * WARNING - void declaration
             */
            public final void set(V value) {
                void var1_1;
                this.getDelegateListIterator().set(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void add(V value) {
                void var2_2;
                void var1_1;
                boolean wasEmpty = this.this$1.isEmpty();
                this.getDelegateListIterator().add(var1_1);
                this.this$1.this$0.totalSize++;
                if (var2_2 != false) {
                    this.this$1.addToMap();
                }
            }
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection, not com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$WrappedCollection - discarding signature.
     */
    final class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet {
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        /*
         * WARNING - void declaration
         */
        WrappedSortedSet(@Nullable K key, SortedSet<V> delegate, @Nullable AbstractMapBasedMultimap.WrappedCollection ancestor) {
            void var3_3;
            void var2_2;
            this.this$0 = var1_1;
            super((AbstractMapBasedMultimap)var1_1, (Object)var2_2, (Collection)var3_3, (WrappedCollection)ancestor);
        }

        private SortedSet<V> getSortedSetDelegate() {
            WrappedSortedSet wrappedSortedSet = this;
            return (SortedSet)wrappedSortedSet.delegate;
        }

        public final Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        public final V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        public final V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        /*
         * WARNING - void declaration
         */
        public final SortedSet<V> headSet(V toElement) {
            WrappedSortedSet wrappedSortedSet;
            void var1_1;
            this.refreshIfEmpty();
            WrappedSortedSet wrappedSortedSet2 = this;
            Object k = wrappedSortedSet2.key;
            SortedSet<void> sortedSet = this.getSortedSetDelegate().headSet(var1_1);
            wrappedSortedSet2 = this;
            if (wrappedSortedSet2.ancestor == null) {
                wrappedSortedSet = this;
            } else {
                wrappedSortedSet2 = this;
                wrappedSortedSet = wrappedSortedSet2.ancestor;
            }
            return new WrappedSortedSet(this.this$0, k, sortedSet, (WrappedCollection)wrappedSortedSet);
        }

        /*
         * WARNING - void declaration
         */
        public final SortedSet<V> subSet(V fromElement, V toElement) {
            WrappedSortedSet wrappedSortedSet;
            void var2_2;
            void var1_1;
            this.refreshIfEmpty();
            WrappedSortedSet wrappedSortedSet2 = this;
            Object k = wrappedSortedSet2.key;
            SortedSet<void> sortedSet = this.getSortedSetDelegate().subSet(var1_1, var2_2);
            wrappedSortedSet2 = this;
            if (wrappedSortedSet2.ancestor == null) {
                wrappedSortedSet = this;
            } else {
                wrappedSortedSet2 = this;
                wrappedSortedSet = wrappedSortedSet2.ancestor;
            }
            return new WrappedSortedSet(this.this$0, k, sortedSet, (WrappedCollection)wrappedSortedSet);
        }

        /*
         * WARNING - void declaration
         */
        public final SortedSet<V> tailSet(V fromElement) {
            WrappedSortedSet wrappedSortedSet;
            void var1_1;
            this.refreshIfEmpty();
            WrappedSortedSet wrappedSortedSet2 = this;
            Object k = wrappedSortedSet2.key;
            SortedSet<void> sortedSet = this.getSortedSetDelegate().tailSet(var1_1);
            wrappedSortedSet2 = this;
            if (wrappedSortedSet2.ancestor == null) {
                wrappedSortedSet = this;
            } else {
                wrappedSortedSet2 = this;
                wrappedSortedSet = wrappedSortedSet2.ancestor;
            }
            return new WrappedSortedSet(this.this$0, k, sortedSet, (WrappedCollection)wrappedSortedSet);
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection, not com.github.igorsuhorukov.google.common.collect.AbstractMapBasedMultimap$WrappedCollection - discarding signature.
     */
    final class WrappedSet
    extends WrappedCollection
    implements Set {
        private /* synthetic */ AbstractMapBasedMultimap this$0;

        /*
         * WARNING - void declaration
         */
        WrappedSet(AbstractMapBasedMultimap abstractMapBasedMultimap, @Nullable K key, Set<V> delegate) {
            void var3_3;
            void var2_2;
            this.this$0 = abstractMapBasedMultimap;
            super(abstractMapBasedMultimap, (Object)var2_2, (Collection)var3_3, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<?> c) {
            void var1_2;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = AbstractBiMap.1.removeAllImpl((Set)this.delegate, c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }
    }

    static class WrappedCollection
    extends AbstractCollection<V> {
        final K key;
        Collection<V> delegate;
        final AbstractMapBasedMultimap.WrappedCollection ancestor;
        private Collection<V> ancestorDelegate;
        final /* synthetic */ AbstractMapBasedMultimap this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        WrappedCollection(@Nullable K key, Collection<V> delegate, @Nullable AbstractMapBasedMultimap.WrappedCollection ancestor) {
            Collection collection;
            void var3_3;
            void var2_2;
            this.this$0 = wrappedCollection;
            this.key = var2_2;
            this.delegate = var3_3;
            this.ancestor = ancestor;
            if (ancestor == null) {
                collection = null;
            } else {
                wrappedCollection = ancestor;
                collection = wrappedCollection.delegate;
            }
            this.ancestorDelegate = collection;
        }

        /*
         * WARNING - void declaration
         */
        final void refreshIfEmpty() {
            Collection newDelegate;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                AbstractMapBasedMultimap.WrappedCollection wrappedCollection = this.ancestor;
                if (wrappedCollection.delegate != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (newDelegate = (Collection)AbstractMapBasedMultimap.access$000(this.this$0).get(this.key)) != null) {
                void var1_2;
                this.delegate = var1_2;
            }
        }

        final void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
                return;
            }
            if (this.delegate.isEmpty()) {
                AbstractMapBasedMultimap.access$000(this.this$0).remove(this.key);
            }
        }

        final void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
                return;
            }
            AbstractMapBasedMultimap.access$000(this.this$0).put(this.key, this.delegate);
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(@Nullable Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(var1_1);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(V value) {
            void var1_2;
            this.refreshIfEmpty();
            boolean wasEmpty = this.delegate.isEmpty();
            boolean changed = this.delegate.add(value);
            if (changed) {
                void var2_3;
                this.this$0.totalSize++;
                if (var2_3 != false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(Collection<? extends V> collection) {
            void var1_2;
            if (collection.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.addAll(collection);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - oldSize));
                if (var2_3 == false) {
                    this.addToMap();
                }
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            this.refreshIfEmpty();
            return this.delegate.contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            this.refreshIfEmpty();
            return this.delegate.containsAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            void var1_1;
            int oldSize = this.size();
            if (oldSize == 0) {
                return;
            }
            this.delegate.clear();
            AbstractMapBasedMultimap.access$220(this.this$0, (int)var1_1);
            this.removeIfEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            void var1_2;
            this.refreshIfEmpty();
            boolean changed = this.delegate.remove(o);
            if (changed) {
                this.this$0.totalSize--;
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var1_2;
            if (c.isEmpty()) {
                return false;
            }
            int oldSize = this.size();
            boolean changed = this.delegate.removeAll(c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            void var1_2;
            Ascii.checkNotNull(c);
            int oldSize = this.size();
            boolean changed = this.delegate.retainAll(c);
            if (changed) {
                void var2_3;
                void var3_4;
                int newSize = this.delegate.size();
                AbstractMapBasedMultimap.access$212(this.this$0, (int)(var3_4 - var2_3));
                this.removeIfEmpty();
            }
            return (boolean)var1_2;
        }

        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            private Collection<V> originalDelegate;
            private /* synthetic */ WrappedCollection this$1;

            WrappedIterator(WrappedCollection wrappedCollection) {
                this.this$1 = wrappedCollection;
                this.originalDelegate = this.this$1.delegate;
                this.delegateIterator = AbstractMapBasedMultimap.access$100(wrappedCollection.this$0, wrappedCollection.delegate);
            }

            /*
             * WARNING - void declaration
             */
            WrappedIterator(WrappedCollection wrappedCollection, Iterator<V> delegateIterator) {
                void var2_2;
                this.this$1 = wrappedCollection;
                this.originalDelegate = this.this$1.delegate;
                this.delegateIterator = var2_2;
            }

            final void validateIterator() {
                this.this$1.refreshIfEmpty();
                if (this.this$1.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                this.this$1.this$0.totalSize--;
                this.this$1.removeIfEmpty();
            }
        }
    }
}

