/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.AbstractBiMap;
import com.github.igorsuhorukov.google.common.collect.AbstractMultiset;
import com.github.igorsuhorukov.google.common.collect.Count;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.collect.Multiset;
import com.github.igorsuhorukov.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private transient long size;

    @Override
    public final Set<Multiset.Entry<E>> entrySet() {
        return super.entrySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Iterator<Multiset.Entry<E>> entryIterator() {
        void var1_1;
        Iterator backingEntries = ((Map)null).entrySet().iterator();
        return new Iterator<Multiset.Entry<E>>((Iterator)var1_1){
            private Map.Entry<E, Count> toRemove;
            private /* synthetic */ Iterator val$backingEntries;
            {
                this.val$backingEntries = iterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$backingEntries.hasNext();
            }

            @Override
            public final void remove() {
                boolean bl = this.toRemove != null;
                Ascii.checkState(bl, "no calls to next() since the last call to remove()");
                AbstractMapBasedMultiset.access$122(AbstractMapBasedMultiset.this, this.toRemove.getValue().getAndSet(0));
                this.val$backingEntries.remove();
                this.toRemove = null;
            }
        };
    }

    @Override
    public void clear() {
        for (Count count : ((Map)null).values()) {
            count.set(0);
        }
        ((Map)null).clear();
        this.size = 0L;
    }

    @Override
    final int distinctElements() {
        return ((Map)null).size();
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public Iterator<E> iterator() {
        return new MapBasedMultisetIterator(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int count(@Nullable Object element) {
        void var1_1;
        Count frequency = (Count)Maps.safeGet(null, element);
        if (frequency == null) {
            return 0;
        }
        return var1_1.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int add(@Nullable E element, int occurrences) {
        void var2_2;
        int oldCount;
        if (occurrences == 0) {
            return this.count(element);
        }
        Ascii.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        Count frequency = (Count)((Map)null).get(element);
        if (frequency == null) {
            void var1_1;
            oldCount = 0;
            ((Map)null).put(var1_1, new Count(occurrences));
        } else {
            void var3_3;
            oldCount = frequency.get();
            long newCount = (long)oldCount + (long)occurrences;
            Ascii.checkArgument(newCount <= Integer.MAX_VALUE, "too many occurrences: %s", newCount);
            var3_3.getAndAdd(occurrences);
        }
        this.size += (long)var2_2;
        return oldCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int remove(@Nullable Object element, int occurrences) {
        void var2_2;
        void var3_3;
        int numberRemoved;
        if (occurrences == 0) {
            return this.count(element);
        }
        Ascii.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        Count frequency = (Count)((Map)null).get(element);
        if (frequency == null) {
            return 0;
        }
        int oldCount = frequency.get();
        if (oldCount <= occurrences) {
            void var1_1;
            numberRemoved = oldCount;
            ((Map)null).remove(var1_1);
        }
        var3_3.addAndGet(-numberRemoved);
        this.size -= (long)var2_2;
        return oldCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int setCount(@Nullable E element, int count) {
        void var2_2;
        int oldCount;
        AbstractBiMap.1.checkNonnegative(count, "count");
        if (count == 0) {
            Count count2 = (Count)((Map)null).remove(element);
            oldCount = AbstractMapBasedMultiset.getAndSet(count2, count);
        } else {
            void var3_4;
            Count existingCounter = (Count)((Map)null).get(element);
            oldCount = AbstractMapBasedMultiset.getAndSet(existingCounter, count);
            if (var3_4 == null) {
                void var1_1;
                ((Map)null).put(var1_1, new Count(count));
            }
        }
        this.size += (long)(var2_2 - oldCount);
        return oldCount;
    }

    /*
     * WARNING - void declaration
     */
    private static int getAndSet(Count i, int count) {
        void var1_1;
        Count count2;
        if (i == null) {
            return 0;
        }
        return count2.getAndSet((int)var1_1);
    }

    static /* synthetic */ Map access$000(AbstractMapBasedMultiset x0) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$122(AbstractMapBasedMultiset x0, long x1) {
        void var1_1;
        return x0.size -= var1_1;
    }

    final class MapBasedMultisetIterator
    implements Iterator<E> {
        private Iterator<Map.Entry<E, Count>> entryIterator;
        private Map.Entry<E, Count> currentEntry;
        private int occurrencesLeft;
        private boolean canRemove;
        private /* synthetic */ AbstractMapBasedMultiset this$0;

        MapBasedMultisetIterator(AbstractMapBasedMultiset abstractMapBasedMultiset) {
            this.this$0 = abstractMapBasedMultiset;
            this.entryIterator = AbstractMapBasedMultiset.access$000(abstractMapBasedMultiset).entrySet().iterator();
        }

        @Override
        public final boolean hasNext() {
            return this.occurrencesLeft > 0 || this.entryIterator.hasNext();
        }

        @Override
        public final E next() {
            if (this.occurrencesLeft == 0) {
                this.currentEntry = this.entryIterator.next();
                this.occurrencesLeft = this.currentEntry.getValue().get();
            }
            --this.occurrencesLeft;
            this.canRemove = true;
            return this.currentEntry.getKey();
        }

        @Override
        public final void remove() {
            int n = this.canRemove;
            Ascii.checkState(n != 0, "no calls to next() since the last call to remove()");
            n = this.currentEntry.getValue().get();
            if (n <= 0) {
                throw new ConcurrentModificationException();
            }
            if (this.currentEntry.getValue().addAndGet(-1) == 0) {
                this.entryIterator.remove();
            }
            this.this$0.size--;
            this.canRemove = false;
        }
    }
}

