/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Multiset;
import com.github.igorsuhorukov.google.common.collect.Multisets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private transient Set<E> elementSet;
    private transient Set<Multiset.Entry<E>> entrySet;

    @Override
    public int size() {
        return Multisets.sizeImpl(this);
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(@Nullable Object element) {
        void var1_1;
        return this.count(var1_1) > 0;
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int count(@Nullable Object element) {
        for (Multiset.Entry<E> entry : this.entrySet()) {
            void var3_3;
            if (!Ascii.equal(entry.getElement(), element)) continue;
            return var3_3.getCount();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(@Nullable E element) {
        void var1_1;
        this.add(var1_1, 1);
        return true;
    }

    @Override
    public int add(@Nullable E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(@Nullable Object element) {
        void var1_1;
        return this.remove(var1_1, 1) > 0;
    }

    @Override
    public int remove(@Nullable Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setCount(@Nullable E element, int count) {
        void var2_2;
        void var1_1;
        return Multisets.setCountImpl(this, var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean setCount(@Nullable E element, int oldCount, int newCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Multisets.setCountImpl(this, var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends E> elementsToAdd) {
        void var1_1;
        return Multisets.addAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(Collection<?> elementsToRemove) {
        void var1_1;
        return Multisets.removeAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> elementsToRetain) {
        void var1_1;
        return Multisets.retainAllImpl(this, var1_1);
    }

    @Override
    public void clear() {
        Iterators.clear(this.entryIterator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<E> elementSet() {
        void var1_1;
        Set<E> result = this.elementSet;
        if (result == null) {
            this.elementSet = result = this.createElementSet();
        }
        return var1_1;
    }

    Set<E> createElementSet() {
        return new ElementSet(this);
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    abstract int distinctElements();

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        void var1_1;
        Set result = this.entrySet;
        if (result == null) {
            result = this;
            this.entrySet = result = new EntrySet((AbstractMultiset)((Object)result));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object object) {
        void var1_1;
        return Multisets.equalsImpl(this, var1_1);
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }

    final class EntrySet
    extends Multisets.EntrySet<E> {
        private /* synthetic */ AbstractMultiset this$0;

        EntrySet(AbstractMultiset abstractMultiset) {
            this.this$0 = abstractMultiset;
        }

        @Override
        final Multiset<E> multiset() {
            return this.this$0;
        }

        @Override
        public final Iterator<Multiset.Entry<E>> iterator() {
            return this.this$0.entryIterator();
        }

        @Override
        public final int size() {
            return this.this$0.distinctElements();
        }
    }

    final class ElementSet
    extends Multisets.ElementSet<E> {
        private /* synthetic */ AbstractMultiset this$0;

        ElementSet(AbstractMultiset abstractMultiset) {
            this.this$0 = abstractMultiset;
        }

        @Override
        final Multiset<E> multiset() {
            return this.this$0;
        }
    }
}

